/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.zeromock.api;

import com.github.tonivade.purefun.Equal;
import com.github.tonivade.zeromock.api.Bytes;
import com.github.tonivade.zeromock.api.HttpHeaders;
import com.github.tonivade.zeromock.api.HttpStatus;
import java.util.Objects;

public final class HttpResponse {
    private static final Equal<HttpResponse> EQUAL = Equal.of().comparing(HttpResponse::status).comparing(HttpResponse::body).comparing(HttpResponse::headers);
    private final HttpStatus status;
    private final Bytes body;
    private final HttpHeaders headers;

    public HttpResponse(HttpStatus status, Bytes body) {
        this(status, body, HttpHeaders.empty());
    }

    public HttpResponse(HttpStatus status, Bytes body, HttpHeaders headers) {
        this.status = Objects.requireNonNull(status);
        this.body = Objects.requireNonNull(body);
        this.headers = Objects.requireNonNull(headers);
    }

    public HttpStatus status() {
        return this.status;
    }

    public Bytes body() {
        return this.body;
    }

    public HttpHeaders headers() {
        return this.headers;
    }

    public HttpResponse withHeader(String key, String value) {
        return new HttpResponse(this.status, this.body, this.headers.withHeader(key, value));
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.body, this.headers});
    }

    public boolean equals(Object obj) {
        return EQUAL.applyTo((Object)this, obj);
    }

    public String toString() {
        return "HttpResponse(" + (Object)((Object)this.status) + " " + Bytes.asString(this.body) + ")";
    }
}

