/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.zeromock.api;

import com.github.tonivade.purefun.Function1;
import com.github.tonivade.purefun.Function2;
import com.github.tonivade.purefun.Matcher1;
import com.github.tonivade.purefun.instances.IdInstances;
import com.github.tonivade.purefun.type.Id;
import com.github.tonivade.purefun.type.IdOf;
import com.github.tonivade.purefun.type.Id_;
import com.github.tonivade.purefun.type.Option;
import com.github.tonivade.zeromock.api.HttpRequest;
import com.github.tonivade.zeromock.api.HttpResponse;
import com.github.tonivade.zeromock.api.HttpServiceK;
import com.github.tonivade.zeromock.api.PostFilter;
import com.github.tonivade.zeromock.api.PreFilter;
import com.github.tonivade.zeromock.api.RequestHandler;
import java.util.Objects;

public final class HttpService {
    private final HttpServiceK<Id_> serviceK;

    public HttpService(String name) {
        this(new HttpServiceK<Id_>(name, IdInstances.monad()));
    }

    private HttpService(HttpServiceK<Id_> serviceK) {
        this.serviceK = Objects.requireNonNull(serviceK);
    }

    public String name() {
        return this.serviceK.name();
    }

    public HttpServiceK<Id_> build() {
        return this.serviceK;
    }

    public HttpService mount(String path, HttpService other) {
        return new HttpService(this.serviceK.mount(path, other.serviceK));
    }

    public HttpService exec(RequestHandler handler) {
        return new HttpService(this.serviceK.exec(arg_0 -> ((Function1)handler.liftId()).apply(arg_0)));
    }

    public MappingBuilder<HttpService> preFilter(Matcher1<HttpRequest> matcher) {
        return new MappingBuilder(this::addPreFilter).when(Objects.requireNonNull(matcher));
    }

    public HttpService preFilter(PreFilter filter) {
        return new HttpService(this.serviceK.preFilter(arg_0 -> ((Function1)filter.liftId()).apply(arg_0)));
    }

    public HttpService postFilter(PostFilter filter) {
        return new HttpService(this.serviceK.postFilter(arg_0 -> ((Function1)filter.liftId()).apply(arg_0)));
    }

    public MappingBuilder<HttpService> when(Matcher1<HttpRequest> matcher) {
        return new MappingBuilder(this::addMapping).when(matcher);
    }

    public Option<HttpResponse> execute(HttpRequest request) {
        return (Option)((Id)this.serviceK.execute(request).fix(IdOf::narrowK)).get();
    }

    public HttpService combine(HttpService other) {
        return new HttpService(this.serviceK.combine(other.serviceK));
    }

    protected HttpService addMapping(Matcher1<HttpRequest> matcher, RequestHandler handler) {
        return new HttpService(this.serviceK.addMapping(matcher, arg_0 -> ((Function1)handler.liftId()).apply(arg_0)));
    }

    protected HttpService addPreFilter(Matcher1<HttpRequest> matcher, RequestHandler handler) {
        return this.preFilter(PreFilter.filter(matcher, handler));
    }

    public String toString() {
        return "HttpService(" + this.serviceK.name() + ")";
    }

    public static final class MappingBuilder<T> {
        private final Function2<Matcher1<HttpRequest>, RequestHandler, T> finisher;
        private Matcher1<HttpRequest> matcher;

        public MappingBuilder(Function2<Matcher1<HttpRequest>, RequestHandler, T> finisher) {
            this.finisher = Objects.requireNonNull(finisher);
        }

        public MappingBuilder<T> when(Matcher1<HttpRequest> matcher) {
            this.matcher = matcher;
            return this;
        }

        public T then(RequestHandler handler) {
            return (T)this.finisher.apply(this.matcher, (Object)handler);
        }
    }
}

