/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.zeromock.api;

import com.github.tonivade.purefun.Function1;
import com.github.tonivade.purefun.Function2;
import com.github.tonivade.purefun.Kind;
import com.github.tonivade.purefun.Matcher1;
import com.github.tonivade.purefun.PartialFunction1;
import com.github.tonivade.purefun.Witness;
import com.github.tonivade.purefun.instances.OptionInstances;
import com.github.tonivade.purefun.type.Either;
import com.github.tonivade.purefun.type.Option;
import com.github.tonivade.purefun.type.OptionOf;
import com.github.tonivade.purefun.typeclasses.For;
import com.github.tonivade.purefun.typeclasses.Monad;
import com.github.tonivade.zeromock.api.HttpRequest;
import com.github.tonivade.zeromock.api.HttpResponse;
import com.github.tonivade.zeromock.api.Matchers;
import com.github.tonivade.zeromock.api.PostFilterK;
import com.github.tonivade.zeromock.api.PreFilterK;
import com.github.tonivade.zeromock.api.RequestHandlerK;
import com.github.tonivade.zeromock.api.Responses;
import java.util.Objects;

public final class HttpServiceK<F extends Witness> {
    private final String name;
    private final Monad<F> monad;
    private final PartialFunction1<HttpRequest, Kind<F, HttpResponse>> mappings;
    private final Function1<HttpRequest, Kind<F, Either<HttpResponse, HttpRequest>>> preFilters;
    private final Function1<HttpResponse, Kind<F, HttpResponse>> postFilters;

    public HttpServiceK(String name, Monad<F> monad) {
        this(name, monad, PartialFunction1.of((Matcher1)Matcher1.never(), (Function1)Function1.fail(IllegalStateException::new)), request -> monad.pure((Object)Either.right((Object)request)), arg_0 -> monad.pure(arg_0));
    }

    private HttpServiceK(String name, Monad<F> monad, PartialFunction1<HttpRequest, Kind<F, HttpResponse>> mappings, Function1<HttpRequest, Kind<F, Either<HttpResponse, HttpRequest>>> preFilters, Function1<HttpResponse, Kind<F, HttpResponse>> postFilters) {
        this.name = Objects.requireNonNull(name);
        this.monad = Objects.requireNonNull(monad);
        this.mappings = Objects.requireNonNull(mappings);
        this.preFilters = Objects.requireNonNull(preFilters);
        this.postFilters = Objects.requireNonNull(postFilters);
    }

    public String name() {
        return this.name;
    }

    public HttpServiceK<F> mount(String path, HttpServiceK<F> other) {
        Objects.requireNonNull(path);
        Objects.requireNonNull(other);
        return this._addMapping((Matcher1<HttpRequest>)Matchers.startsWith(path).and(req -> other.mappings.isDefinedAt((Object)req.dropOneLevel())), req -> this.monad.map(other.execute(req.dropOneLevel()), option -> (HttpResponse)option.getOrElse((Object)Responses.notFound())));
    }

    public HttpServiceK<F> exec(RequestHandlerK<F> handler) {
        return this._addMapping(Matchers.all(), handler);
    }

    public MappingBuilderK<F, HttpServiceK<F>> when(Matcher1<HttpRequest> matcher) {
        return new MappingBuilderK(this::addMapping).when(Objects.requireNonNull(matcher));
    }

    public MappingBuilderK<F, HttpServiceK<F>> preFilter(Matcher1<HttpRequest> matcher) {
        return new MappingBuilderK(this::addPreFilter).when(Objects.requireNonNull(matcher));
    }

    public HttpServiceK<F> preFilter(PreFilterK<F> filter) {
        return this._addPreFilter(Objects.requireNonNull(filter));
    }

    public HttpServiceK<F> postFilter(PostFilterK<F> filter) {
        return this._addPostFilter(Objects.requireNonNull(filter));
    }

    public Kind<F, Option<HttpResponse>> execute(HttpRequest request) {
        Function1 mappingsWithPostFilters = this.mappings.andThen(value -> this.monad.flatMap(value, arg_0 -> this.postFilters.apply(arg_0))).lift();
        return For.with(this.monad).then((Kind)this.preFilters.apply((Object)request)).flatMap(either -> (Kind)either.fold(res -> this.monad.pure((Object)Option.some((Object)res)), mappingsWithPostFilters.andThen(option -> OptionInstances.traverse().sequence(this.monad, (Kind)option)))).map(OptionOf::narrowK).run();
    }

    public HttpServiceK<F> combine(HttpServiceK<F> other) {
        Objects.requireNonNull(other);
        return new HttpServiceK<F>(this.name + "+" + other.name, this.monad, this.mappings.orElse(other.mappings), this.preFilters.andThen(value -> this.monad.flatMap(value, either -> (Kind)either.fold(response -> this.monad.pure((Object)Either.left((Object)response)), other.preFilters))), arg_0 -> ((Function1)this.postFilters.andThen(value -> this.monad.flatMap(value, other.postFilters))).apply(arg_0));
    }

    public HttpServiceK<F> addMapping(Matcher1<HttpRequest> matcher, RequestHandlerK<F> handler) {
        return this._addMapping(matcher, handler);
    }

    public HttpServiceK<F> addPreFilter(Matcher1<HttpRequest> matcher, RequestHandlerK<F> handler) {
        return this._addPreFilter(PreFilterK.filter(this.monad, matcher, handler));
    }

    private HttpServiceK<F> _addMapping(Matcher1<HttpRequest> matcher, RequestHandlerK<F> handler) {
        Objects.requireNonNull(matcher);
        Objects.requireNonNull(handler);
        return new HttpServiceK<F>(this.name, this.monad, this.mappings.orElse(PartialFunction1.of(matcher, arg_0 -> handler.apply(arg_0))), this.preFilters, this.postFilters);
    }

    private HttpServiceK<F> _addPreFilter(PreFilterK<F> filter) {
        Objects.requireNonNull(filter);
        return new HttpServiceK<F>(this.name, this.monad, this.mappings, this.preFilters.andThen(value -> this.monad.flatMap(value, either -> (Kind)either.fold(response -> this.monad.pure((Object)Either.left((Object)response)), (Function1)filter))), this.postFilters);
    }

    private HttpServiceK<F> _addPostFilter(PostFilterK<F> filter) {
        Objects.requireNonNull(filter);
        return new HttpServiceK<F>(this.name, this.monad, this.mappings, this.preFilters, arg_0 -> ((Function1)this.postFilters.andThen(value -> this.monad.flatMap(value, (Function1)filter))).apply(arg_0));
    }

    public static final class MappingBuilderK<F extends Witness, T> {
        private final Function2<Matcher1<HttpRequest>, RequestHandlerK<F>, T> finisher;
        private Matcher1<HttpRequest> matcher;

        public MappingBuilderK(Function2<Matcher1<HttpRequest>, RequestHandlerK<F>, T> finisher) {
            this.finisher = Objects.requireNonNull(finisher);
        }

        public MappingBuilderK<F, T> when(Matcher1<HttpRequest> matcher) {
            this.matcher = Objects.requireNonNull(matcher);
            return this;
        }

        public T then(RequestHandlerK<F> handler) {
            return (T)this.finisher.apply(this.matcher, handler);
        }
    }
}

