/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.zeromock.api;

import com.github.tonivade.zeromock.api.Bytes;
import com.github.tonivade.zeromock.api.HttpResponse;
import com.github.tonivade.zeromock.api.HttpStatus;
import java.util.Objects;

public final class Responses {
    private Responses() {
    }

    public static HttpResponse ok() {
        return Responses.ok(Bytes.empty());
    }

    public static HttpResponse ok(String body) {
        return Responses.ok(Bytes.asBytes(body));
    }

    public static HttpResponse ok(Bytes body) {
        return new HttpResponse(HttpStatus.OK, body);
    }

    public static HttpResponse created(String body) {
        return Responses.created(Bytes.asBytes(body));
    }

    public static HttpResponse created(Bytes body) {
        return new HttpResponse(HttpStatus.CREATED, body);
    }

    public static HttpResponse noContent() {
        return new HttpResponse(HttpStatus.NO_CONTENT, Bytes.empty());
    }

    public static HttpResponse forbidden() {
        return new HttpResponse(HttpStatus.FORBIDDEN, Bytes.empty());
    }

    public static HttpResponse badRequest() {
        return Responses.badRequest(Bytes.empty());
    }

    public static HttpResponse badRequest(String body) {
        return Responses.badRequest(Bytes.asBytes(body));
    }

    public static HttpResponse badRequest(Bytes body) {
        return new HttpResponse(HttpStatus.BAD_REQUEST, body);
    }

    public static HttpResponse notFound() {
        return Responses.notFound(Bytes.empty());
    }

    public static HttpResponse notFound(String body) {
        return Responses.notFound(Bytes.asBytes(body));
    }

    public static HttpResponse notFound(Bytes body) {
        return new HttpResponse(HttpStatus.NOT_FOUND, body);
    }

    public static HttpResponse unauthorized() {
        return Responses.unauthorized(Bytes.empty());
    }

    public static HttpResponse unauthorized(String body) {
        return Responses.unauthorized(Bytes.asBytes(body));
    }

    public static HttpResponse unauthorized(Bytes body) {
        return new HttpResponse(HttpStatus.UNAUTHORIZED, body);
    }

    public static HttpResponse error() {
        return Responses.error(Bytes.empty());
    }

    public static HttpResponse error(String body) {
        return Responses.error(Bytes.asBytes(Objects.requireNonNull(body)));
    }

    public static HttpResponse error(Throwable error) {
        return Responses.error(error.getMessage());
    }

    public static HttpResponse error(Bytes body) {
        return new HttpResponse(HttpStatus.INTERNAL_SERVER_ERROR, body);
    }

    public static HttpResponse unavailable() {
        return Responses.unavailable(Bytes.empty());
    }

    public static HttpResponse unavailable(String body) {
        return Responses.unavailable(Bytes.asBytes(body));
    }

    public static HttpResponse unavailable(Bytes body) {
        return new HttpResponse(HttpStatus.SERVICE_UNAVAILABLE, body);
    }
}

