/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.zeromock.api;

import com.github.tonivade.purefun.Function1;
import com.github.tonivade.purefun.data.ImmutableArray;
import com.github.tonivade.purefun.data.ImmutableList;
import com.github.tonivade.purefun.data.ImmutableMap;
import com.github.tonivade.purefun.data.ImmutableSet;
import com.github.tonivade.purefun.data.ImmutableTree;
import com.github.tonivade.purefun.data.ImmutableTreeMap;
import com.github.tonivade.zeromock.api.Bytes;
import com.github.tonivade.zeromock.api.ImmutableArraySerializerAdapter;
import com.github.tonivade.zeromock.api.ImmutableListSerializerAdapter;
import com.github.tonivade.zeromock.api.ImmutableMapSerializerAdapter;
import com.github.tonivade.zeromock.api.ImmutableSetSerializerAdapter;
import com.github.tonivade.zeromock.api.ImmutableTreeSerializerAdapter;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

public final class Serializers {
    private Serializers() {
    }

    public static <T> Function1<T, Bytes> empty() {
        return Function1.cons((Object)Bytes.empty());
    }

    public static Function1<Throwable, Bytes> throwableToJson() {
        return Function1.of(Serializers::toJson).andThen(Bytes::asBytes);
    }

    public static <T> Function1<T, Bytes> objectToJson() {
        return Function1.of(Serializers::toJson).andThen(Bytes::asBytes);
    }

    public static <T> Function1<T, Bytes> objectToXml() {
        return Function1.of(Serializers::toXml).andThen(Bytes::asBytes);
    }

    public static <T> Function1<T, Bytes> plain() {
        return Function1.of(Object::toString).andThen(Bytes::asBytes);
    }

    private static <T> String toJson(T value) {
        return Serializers.buildGson().toJson(value);
    }

    private static String toJson(Throwable error) {
        return Serializers.toJson(Serializers.throwableToJson(error));
    }

    private static JsonObject throwableToJson(Throwable error) {
        JsonObject json = new JsonObject();
        json.addProperty("type", error.getClass().getName());
        json.addProperty("message", error.getMessage());
        json.add("trace", Serializers.stacktrace(error.getStackTrace()));
        return json;
    }

    private static <T> String toXml(T value) {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{value.getClass()});
            StringWriter writer = new StringWriter();
            Marshaller marshaller = context.createMarshaller();
            marshaller.marshal(value, (Writer)writer);
            return writer.toString();
        }
        catch (JAXBException e) {
            throw new UncheckedIOException(new IOException(e));
        }
    }

    private static JsonElement stacktrace(StackTraceElement[] stackTrace) {
        JsonArray array = new JsonArray();
        for (StackTraceElement stackTraceElement : stackTrace) {
            array.add(stackTraceElement.toString());
        }
        return array;
    }

    private static Gson buildGson() {
        return new GsonBuilder().registerTypeAdapter(ImmutableList.JavaBasedImmutableList.class, (Object)new ImmutableListSerializerAdapter()).registerTypeAdapter(ImmutableArray.JavaBasedImmutableArray.class, (Object)new ImmutableArraySerializerAdapter()).registerTypeAdapter(ImmutableSet.JavaBasedImmutableSet.class, (Object)new ImmutableSetSerializerAdapter()).registerTypeAdapter(ImmutableTree.JavaBasedImmutableTree.class, (Object)new ImmutableTreeSerializerAdapter()).registerTypeAdapter(ImmutableMap.JavaBasedImmutableMap.class, (Object)new ImmutableMapSerializerAdapter()).registerTypeAdapter(ImmutableTreeMap.JavaBasedImmutableTreeMap.class, (Object)new ImmutableMapSerializerAdapter()).create();
    }
}

