/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.zeromock.api;

import com.github.tonivade.purefun.Kind;
import com.github.tonivade.purefun.concurrent.Future;
import com.github.tonivade.purefun.concurrent.FutureOf;
import com.github.tonivade.purefun.concurrent.Promise;
import com.github.tonivade.purefun.core.Matcher1;
import com.github.tonivade.purefun.type.Option;
import com.github.tonivade.purefun.typeclasses.Instance;
import com.github.tonivade.purefun.typeclasses.Instances;
import com.github.tonivade.zeromock.api.HttpRequest;
import com.github.tonivade.zeromock.api.HttpResponse;
import com.github.tonivade.zeromock.api.HttpRouteBuilderK;
import com.github.tonivade.zeromock.api.HttpServiceK;
import com.github.tonivade.zeromock.api.PostFilter;
import com.github.tonivade.zeromock.api.PostFilterK;
import com.github.tonivade.zeromock.api.PreFilter;
import com.github.tonivade.zeromock.api.PreFilterK;
import com.github.tonivade.zeromock.api.RequestHandlerK;
import java.util.Objects;
import java.util.concurrent.Executor;

public final class AsyncHttpService
implements HttpRouteBuilderK<Future<?>, AsyncHttpService> {
    private final HttpServiceK<Future<?>> serviceK;

    public AsyncHttpService(String name) {
        this(name, Future.DEFAULT_EXECUTOR);
    }

    public AsyncHttpService(String name, Executor executor) {
        this(new HttpServiceK(name, new Instance<Future<?>>(){}.monad(new Object[]{executor})));
    }

    private AsyncHttpService(HttpServiceK<Future<?>> serviceK) {
        this.serviceK = Objects.requireNonNull(serviceK);
    }

    public String name() {
        return this.serviceK.name();
    }

    public HttpServiceK<Future<?>> build() {
        return this.serviceK;
    }

    public AsyncHttpService mount(String path, AsyncHttpService other) {
        return new AsyncHttpService(this.serviceK.mount(path, other.serviceK));
    }

    public AsyncHttpService exec(RequestHandlerK<Future<?>> handler) {
        return new AsyncHttpService(this.serviceK.exec(handler));
    }

    public HttpRouteBuilderK.ThenStepK<Future<?>, AsyncHttpService> preFilter(Matcher1<HttpRequest> matcher) {
        return new HttpRouteBuilderK.ThenStepK(Instances.monad((Kind[])new Future[0]), handler -> this.addPreFilter(matcher, (RequestHandlerK<Future<?>>)handler));
    }

    public AsyncHttpService preFilter(PreFilter filter) {
        return this.preFilter(filter.lift(this.serviceK.monad()));
    }

    public AsyncHttpService preFilter(PreFilterK<Future<?>> filter) {
        return new AsyncHttpService(this.serviceK.preFilter(filter));
    }

    public AsyncHttpService postFilter(PostFilter filter) {
        return this.postFilter(filter.lift(this.serviceK.monad()));
    }

    public AsyncHttpService postFilter(PostFilterK<Future<?>> filter) {
        return new AsyncHttpService(this.serviceK.postFilter(filter));
    }

    @Override
    public HttpRouteBuilderK.ThenStepK<Future<?>, AsyncHttpService> when(Matcher1<HttpRequest> matcher) {
        return new HttpRouteBuilderK.ThenStepK(Instances.monad((Kind[])new Future[0]), handler -> this.addMapping(matcher, (RequestHandlerK<Future<?>>)handler));
    }

    public Promise<Option<HttpResponse>> execute(HttpRequest request) {
        return ((Future)this.serviceK.execute(request).fix(FutureOf::toFuture)).toPromise();
    }

    public AsyncHttpService combine(AsyncHttpService other) {
        return new AsyncHttpService(this.serviceK.combine(other.serviceK));
    }

    private AsyncHttpService addMapping(Matcher1<HttpRequest> matcher, RequestHandlerK<Future<?>> handler) {
        return new AsyncHttpService(this.serviceK.addMapping(matcher, handler));
    }

    private AsyncHttpService addPreFilter(Matcher1<HttpRequest> matcher, RequestHandlerK<Future<?>> handler) {
        return this.preFilter(PreFilterK.filter(this.serviceK.monad(), matcher, handler));
    }

    public String toString() {
        return "AsyncHttpService(" + this.serviceK.name() + ")";
    }
}

