/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.zeromock.api;

import com.github.tonivade.purefun.core.Function1;
import com.github.tonivade.purefun.type.Option;
import com.github.tonivade.purefun.type.Try;
import com.github.tonivade.purejson.JsonNode;
import com.github.tonivade.purejson.PureJson;
import com.github.tonivade.zeromock.api.Bytes;
import jakarta.xml.bind.DataBindingException;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Type;

public final class Deserializers {
    private Deserializers() {
    }

    public static Function1<Bytes, Try<JsonNode>> json() {
        return Deserializers.plain().andThen(Deserializers.asJson());
    }

    @SafeVarargs
    public static <T> Function1<Bytes, Try<T>> xmlToObject(T ... reified) {
        return Deserializers.xmlToObject(Deserializers.getClassOf(reified));
    }

    public static <T> Function1<Bytes, Try<T>> xmlToObject(Class<T> clazz) {
        return bytes -> Try.of(() -> Deserializers.fromXml(bytes, clazz));
    }

    public static <T> Function1<Bytes, Try<T>> jsonToObject(Function1<String, T> deserializer) {
        return Deserializers.toObject(deserializer.liftTry());
    }

    @SafeVarargs
    public static <T> Function1<Bytes, Try<Option<T>>> jsonToObject(T ... reified) {
        return Deserializers.jsonToObject(Deserializers.getClassOf(reified));
    }

    public static <T> Function1<Bytes, Try<Option<T>>> jsonToObject(Class<T> clazz) {
        return Deserializers.toObject(Deserializers.fromJson(clazz));
    }

    public static <T> Function1<Bytes, Try<Option<T>>> jsonTo(Type type) {
        return Deserializers.toObject(Deserializers.fromJson(type));
    }

    public static Function1<Bytes, String> plain() {
        return Bytes::asString;
    }

    private static Function1<String, Try<JsonNode>> asJson() {
        return PureJson::parse;
    }

    private static <T> Function1<String, Try<Option<T>>> fromJson(Type type) {
        return json -> Deserializers.fromJson(json, type);
    }

    public static <T> Function1<Bytes, Try<T>> toObject(Function1<String, Try<T>> deserializer) {
        return Deserializers.plain().andThen(deserializer);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> T fromXml(Bytes bytes, Class<T> clazz) {
        try (ByteArrayInputStream input = new ByteArrayInputStream(bytes.toArray());){
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{clazz});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            Object object = unmarshaller.unmarshal((InputStream)input);
            return (T)object;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (JAXBException e) {
            throw new DataBindingException((Throwable)e);
        }
    }

    private static <T> Try<Option<T>> fromJson(String json, Type type) {
        return new PureJson(type).fromJson(json);
    }

    private static <T> Class<T> getClassOf(T ... reified) {
        if (reified.length > 0) {
            throw new IllegalArgumentException("do not pass arguments to this function, it's just a trick to get refied types");
        }
        return reified.getClass().getComponentType();
    }
}

