/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.zeromock.api;

import com.github.tonivade.purefun.Kind;
import com.github.tonivade.purefun.core.Consumer2;
import com.github.tonivade.purefun.core.Equal;
import com.github.tonivade.purefun.core.Tuple;
import com.github.tonivade.purefun.core.Tuple2;
import com.github.tonivade.purefun.data.ImmutableMap;
import com.github.tonivade.purefun.data.ImmutableSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class HttpHeaders
implements Iterable<Tuple2<String, String>> {
    private static final Equal<HttpHeaders> EQUAL = Equal.of().comparing(h -> h.headers);
    private final ImmutableMap<String, ImmutableSet<String>> headers;

    public HttpHeaders(ImmutableMap<String, ImmutableSet<String>> headers) {
        this.headers = Objects.requireNonNull(headers).mapKeys(String::toLowerCase);
    }

    @Override
    public Iterator<Tuple2<String, String>> iterator() {
        return this.headers.entries().flatMap(t -> (Kind)t.applyTo((key, values) -> values.map(v -> Tuple2.of((Object)key, (Object)v)))).iterator();
    }

    public HttpHeaders withHeader(String key, String value) {
        return new HttpHeaders((ImmutableMap<String, ImmutableSet<String>>)this.headers.merge((Object)key.toLowerCase(), (Object)ImmutableSet.of((Object[])new String[]{value}), ImmutableSet::union));
    }

    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    public boolean contains(String key) {
        return this.headers.containsKey((Object)key.toLowerCase());
    }

    public ImmutableSet<String> get(String key) {
        return (ImmutableSet)this.headers.getOrDefault((Object)key.toLowerCase(), ImmutableSet::empty);
    }

    public void forEach(Consumer2<String, String> consumer) {
        this.headers.forEach((key, values) -> values.forEach(value -> consumer.accept(key, value)));
    }

    public static HttpHeaders empty() {
        return new HttpHeaders((ImmutableMap<String, ImmutableSet<String>>)ImmutableMap.empty());
    }

    public int hashCode() {
        return Objects.hash(this.headers);
    }

    public boolean equals(Object obj) {
        return EQUAL.applyTo((Object)this, obj);
    }

    public String toString() {
        return "HttpHeaders(" + String.valueOf(this.headers) + ")";
    }

    public static HttpHeaders from(Map<String, List<String>> headers) {
        return new HttpHeaders(HttpHeaders.convert(headers));
    }

    private static ImmutableMap<String, ImmutableSet<String>> convert(Map<String, List<String>> headerFields) {
        return ImmutableMap.from(HttpHeaders.toTuples(headerFields)).mapValues(ImmutableSet::from);
    }

    private static ImmutableSet<Tuple2<String, List<String>>> toTuples(Map<String, List<String>> headerFields) {
        return ImmutableSet.from(headerFields.entrySet()).filter(entry -> Objects.nonNull(entry.getKey())).map(Tuple::from);
    }
}

