/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.zeromock.api;

import com.github.tonivade.purefun.Kind;
import com.github.tonivade.purefun.core.Matcher1;
import com.github.tonivade.purefun.monad.IO;
import com.github.tonivade.purefun.monad.IOOf;
import com.github.tonivade.purefun.type.Option;
import com.github.tonivade.purefun.typeclasses.Instances;
import com.github.tonivade.zeromock.api.HttpRequest;
import com.github.tonivade.zeromock.api.HttpResponse;
import com.github.tonivade.zeromock.api.HttpRouteBuilderK;
import com.github.tonivade.zeromock.api.HttpServiceK;
import com.github.tonivade.zeromock.api.PostFilter;
import com.github.tonivade.zeromock.api.PostFilterK;
import com.github.tonivade.zeromock.api.PreFilter;
import com.github.tonivade.zeromock.api.PreFilterK;
import com.github.tonivade.zeromock.api.RequestHandlerK;
import java.util.Objects;

public final class HttpIOService
implements HttpRouteBuilderK<IO<?>, HttpIOService> {
    private final HttpServiceK<IO<?>> serviceK;

    public HttpIOService(String name) {
        this(new HttpServiceK(name, Instances.monad((Kind[])new IO[0])));
    }

    private HttpIOService(HttpServiceK<IO<?>> serviceK) {
        this.serviceK = Objects.requireNonNull(serviceK);
    }

    public String name() {
        return this.serviceK.name();
    }

    public HttpIOService mount(String path, HttpIOService other) {
        return new HttpIOService(this.serviceK.mount(path, other.serviceK));
    }

    public HttpIOService exec(RequestHandlerK<IO<?>> handler) {
        return new HttpIOService(this.serviceK.exec(handler));
    }

    public HttpRouteBuilderK.ThenStepK<IO<?>, HttpIOService> preFilter(Matcher1<HttpRequest> matcher) {
        return new HttpRouteBuilderK.ThenStepK(this.serviceK.monad(), handler -> this.addPreFilter(matcher, (RequestHandlerK<IO<?>>)handler));
    }

    public HttpIOService preFilter(PreFilter filter) {
        return this.preFilter(filter.lift(this.serviceK.monad()));
    }

    public HttpIOService preFilter(PreFilterK<IO<?>> filter) {
        return new HttpIOService(this.serviceK.preFilter(filter));
    }

    public HttpIOService postFilter(PostFilter filter) {
        return this.postFilter(filter.lift(this.serviceK.monad()));
    }

    public HttpIOService postFilter(PostFilterK<IO<?>> filter) {
        return new HttpIOService(this.serviceK.postFilter(filter));
    }

    @Override
    public HttpRouteBuilderK.ThenStepK<IO<?>, HttpIOService> when(Matcher1<HttpRequest> matcher) {
        return new HttpRouteBuilderK.ThenStepK(this.serviceK.monad(), handler -> this.addMapping(matcher, (RequestHandlerK<IO<?>>)handler));
    }

    public IO<Option<HttpResponse>> execute(HttpRequest request) {
        return (IO)this.serviceK.execute(request).fix(IOOf::toIO);
    }

    public HttpIOService combine(HttpIOService other) {
        return new HttpIOService(this.serviceK.combine(other.serviceK));
    }

    public HttpServiceK<IO<?>> build() {
        return this.serviceK;
    }

    public HttpIOService addMapping(Matcher1<HttpRequest> matcher, RequestHandlerK<IO<?>> handler) {
        return new HttpIOService(this.serviceK.addMapping(matcher, handler));
    }

    private HttpIOService addPreFilter(Matcher1<HttpRequest> matcher, RequestHandlerK<IO<?>> handler) {
        return this.preFilter(PreFilterK.filter(this.serviceK.monad(), matcher, handler));
    }

    public String toString() {
        return "HttpIOService(" + this.serviceK.name() + ")";
    }
}

