/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.zeromock.api;

import com.github.tonivade.purefun.core.Equal;
import com.github.tonivade.purefun.core.Tuple2;
import com.github.tonivade.purefun.data.ImmutableMap;
import com.github.tonivade.purefun.type.Option;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class HttpParams {
    private static final Equal<HttpParams> EQUAL = Equal.of().comparing(h -> h.params);
    private static final String BEGIN = "?";
    private static final String EMPTY = "";
    private static final String EQUALS = "=";
    private static final String SEPARATOR = "&";
    private final ImmutableMap<String, String> params;

    public HttpParams(String queryParams) {
        this(HttpParams.queryToMap(queryParams));
    }

    public HttpParams(ImmutableMap<String, String> params) {
        this.params = Objects.requireNonNull(params);
    }

    public Option<String> get(String name) {
        return this.params.get((Object)name);
    }

    public boolean isEmpty() {
        return this.params.isEmpty();
    }

    public boolean contains(String name) {
        return this.params.containsKey((Object)name);
    }

    public HttpParams withParam(String key, String value) {
        return new HttpParams((ImmutableMap<String, String>)this.params.put((Object)key, (Object)value));
    }

    public String toQueryString() {
        return this.params.isEmpty() ? EMPTY : this.paramsToString();
    }

    public int hashCode() {
        return Objects.hash(this.params);
    }

    public boolean equals(Object obj) {
        return EQUAL.applyTo((Object)this, obj);
    }

    public String toString() {
        return "HttpParams(" + String.valueOf(this.params) + ")";
    }

    public static HttpParams empty() {
        return new HttpParams((ImmutableMap<String, String>)ImmutableMap.empty());
    }

    private static ImmutableMap<String, String> queryToMap(String query) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (query != null) {
            for (String param : query.split(SEPARATOR)) {
                String[] pair = param.split(EQUALS);
                if (pair.length > 1) {
                    result.put(pair[0], HttpParams.urlDecode(pair[1]));
                    continue;
                }
                result.put(pair[0], EMPTY);
            }
        }
        return ImmutableMap.from(result);
    }

    private String paramsToString() {
        return BEGIN + this.params.entries().stream().map(this.entryToString()).collect(Collectors.joining(SEPARATOR));
    }

    private Function<Tuple2<String, String>, String> entryToString() {
        return entry -> (String)entry.get1() + EQUALS + HttpParams.urlEncode((String)entry.get2());
    }

    private static String urlEncode(String value) {
        return URLEncoder.encode(value, StandardCharsets.UTF_8);
    }

    private static String urlDecode(String value) {
        return URLDecoder.decode(value, StandardCharsets.UTF_8);
    }
}

