/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.zeromock.api;

import com.github.tonivade.purefun.core.Equal;
import com.github.tonivade.purefun.data.ImmutableList;
import com.github.tonivade.purefun.type.Option;
import java.util.Arrays;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class HttpPath {
    private static final Equal<HttpPath> EQUAL = Equal.of().comparing(h -> h.value);
    private static final String ROOT = "/";
    private static final String PARAM_PREFIX = ":";
    private final ImmutableList<PathElement> value;

    private HttpPath(ImmutableList<PathElement> path) {
        this.value = Objects.requireNonNull(path);
    }

    public HttpPath dropOneLevel() {
        return new HttpPath((ImmutableList<PathElement>)this.value.tail());
    }

    public int size() {
        return this.value.size();
    }

    public Option<PathElement> getAt(int position) {
        return this.value.drop(position).head();
    }

    public boolean match(HttpPath other) {
        return Pattern.matches(other.toPattern(), this.toPattern());
    }

    public boolean startsWith(HttpPath other) {
        return Pattern.matches(other.toPattern() + ".*", this.toPattern());
    }

    public String toPath() {
        return ROOT + this.value.stream().map(PathElement::toString).collect(Collectors.joining(ROOT));
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        return EQUAL.applyTo((Object)this, obj);
    }

    public String toString() {
        return "Path(" + this.value.toString() + ")";
    }

    private String toPattern() {
        return ROOT + this.value.stream().map(PathElement::toPattern).collect(Collectors.joining(ROOT));
    }

    public static HttpPath of(String ... path) {
        if (Objects.isNull(path)) {
            throw new IllegalArgumentException("invalid path definition: " + Arrays.toString(path));
        }
        return new HttpPath((ImmutableList<PathElement>)ImmutableList.of((Object[])path).map(HttpPath::toPathElement));
    }

    public static HttpPath from(String path) {
        if (Objects.isNull(path) || !path.startsWith(ROOT)) {
            throw new IllegalArgumentException("invalid path: " + path);
        }
        return new HttpPath((ImmutableList<PathElement>)ImmutableList.of((Object[])path.split(ROOT)).tail().map(HttpPath::toPathElement));
    }

    private static PathElement toPathElement(String value) {
        if (value.startsWith(PARAM_PREFIX)) {
            return new PathParam(value.substring(1));
        }
        return new PathValue(value);
    }

    private static final class PathParam
    extends PathElement {
        private PathParam(String value) {
            super(value);
        }

        @Override
        protected String toPattern() {
            return "\\w+";
        }
    }

    private static final class PathValue
    extends PathElement {
        private PathValue(String value) {
            super(value);
        }

        @Override
        protected String toPattern() {
            return super.value();
        }
    }

    public static abstract class PathElement {
        private static final Equal<PathElement> EQUAL = Equal.of().comparing(PathElement::value);
        private final String value;

        private PathElement(String value) {
            this.value = Objects.requireNonNull(value);
        }

        public String value() {
            return this.value;
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public boolean equals(Object obj) {
            return EQUAL.applyTo((Object)this, obj);
        }

        public String toString() {
            return this.value;
        }

        protected abstract String toPattern();
    }
}

