/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.zeromock.api;

import com.github.tonivade.purefun.core.Equal;
import com.github.tonivade.zeromock.api.Bytes;
import com.github.tonivade.zeromock.api.HttpHeaders;
import com.github.tonivade.zeromock.api.HttpMethod;
import com.github.tonivade.zeromock.api.HttpParams;
import com.github.tonivade.zeromock.api.HttpPath;
import java.util.Objects;

public final class HttpRequest {
    private static final Equal<HttpRequest> EQUAL = Equal.of().comparing(HttpRequest::method).comparing(HttpRequest::path).comparing(HttpRequest::body).comparing(HttpRequest::headers).comparing(HttpRequest::params);
    private final HttpMethod method;
    private final HttpPath path;
    private final Bytes body;
    private final HttpHeaders headers;
    private final HttpParams params;

    public HttpRequest(HttpMethod method, HttpPath path) {
        this(method, path, Bytes.empty(), HttpHeaders.empty(), HttpParams.empty());
    }

    public HttpRequest(HttpMethod method, HttpPath path, Bytes body, HttpHeaders headers, HttpParams params) {
        this.method = Objects.requireNonNull(method);
        this.path = Objects.requireNonNull(path);
        this.body = Objects.requireNonNull(body);
        this.headers = Objects.requireNonNull(headers);
        this.params = Objects.requireNonNull(params);
    }

    public HttpMethod method() {
        return this.method;
    }

    public HttpPath path() {
        return this.path;
    }

    public Bytes body() {
        return this.body;
    }

    public HttpHeaders headers() {
        return this.headers;
    }

    public HttpParams params() {
        return this.params;
    }

    public String param(String name) {
        return (String)this.params.get(name).getOrElseThrow(IllegalArgumentException::new);
    }

    public String pathParam(int position) {
        return (String)this.path.getAt(position).map(HttpPath.PathElement::value).getOrElseThrow(IllegalArgumentException::new);
    }

    public String toUrl() {
        return this.path.toPath() + this.params.toQueryString();
    }

    public HttpRequest dropOneLevel() {
        return new HttpRequest(this.method, this.path.dropOneLevel(), this.body, this.headers, this.params);
    }

    public HttpRequest withHeader(String key, String value) {
        return new HttpRequest(this.method, this.path, this.body, this.headers.withHeader(key, value), this.params);
    }

    public HttpRequest withBody(String body) {
        return this.withBody(Bytes.asBytes(body));
    }

    public HttpRequest withBody(Bytes body) {
        return new HttpRequest(this.method, this.path, body, this.headers, this.params);
    }

    public HttpRequest withParam(String key, String value) {
        return new HttpRequest(this.method, this.path, this.body, this.headers, this.params.withParam(key, value));
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.method, this.path, this.body, this.headers, this.params});
    }

    public boolean equals(Object obj) {
        return EQUAL.applyTo((Object)this, obj);
    }

    public String toString() {
        return "HttpRequest(" + String.valueOf((Object)this.method) + " " + this.toUrl() + ")";
    }
}

