/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.zeromock.api;

import com.github.tonivade.purefun.Kind;
import com.github.tonivade.purefun.core.Function1;
import com.github.tonivade.purefun.core.Matcher1;
import com.github.tonivade.purefun.core.Precondition;
import com.github.tonivade.purefun.typeclasses.Monad;
import com.github.tonivade.zeromock.api.Handlers;
import com.github.tonivade.zeromock.api.HttpRequest;
import com.github.tonivade.zeromock.api.RequestHandlerK;
import com.github.tonivade.zeromock.api.RouteBuilder;

public interface HttpRouteBuilderK<F extends Kind<F, ?>, R extends HttpRouteBuilderK<F, R>>
extends RouteBuilder<ThenStepK<F, R>> {
    @Override
    public ThenStepK<F, R> when(Matcher1<HttpRequest> var1);

    public static class ThenStepK<F extends Kind<F, ?>, R extends HttpRouteBuilderK<F, R>> {
        private final Monad<F> monad;
        private final Function1<RequestHandlerK<F>, R> then;

        public ThenStepK(Monad<F> monad, Function1<RequestHandlerK<F>, R> then) {
            this.monad = (Monad)Precondition.checkNonNull(monad);
            this.then = (Function1)Precondition.checkNonNull(then);
        }

        public Monad<F> monad() {
            return this.monad;
        }

        public R then(RequestHandlerK<F> handler) {
            return (R)((HttpRouteBuilderK)this.then.apply(handler));
        }

        public R ok(String body) {
            return this.then(Handlers.ok(body).lift(this.monad));
        }

        public R created(String body) {
            return this.then(Handlers.created(body).lift(this.monad));
        }

        public R error(String body) {
            return this.then(Handlers.error(body).lift(this.monad));
        }

        public R noContent() {
            return this.then(Handlers.noContent().lift(this.monad));
        }

        public R notFound() {
            return this.then(Handlers.notFound().lift(this.monad));
        }

        public R forbidden() {
            return this.then(Handlers.forbidden().lift(this.monad));
        }

        public R badRequest() {
            return this.then(Handlers.badRequest().lift(this.monad));
        }

        public R unauthorized() {
            return this.then(Handlers.unauthorized().lift(this.monad));
        }

        public R unavailable() {
            return this.then(Handlers.unavailable().lift(this.monad));
        }

        public R error() {
            return this.then(Handlers.error().lift(this.monad));
        }
    }
}

