/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.zeromock.api;

import com.github.tonivade.purefun.Kind;
import com.github.tonivade.purefun.core.Matcher1;
import com.github.tonivade.purefun.type.Id;
import com.github.tonivade.purefun.type.IdOf;
import com.github.tonivade.purefun.type.Option;
import com.github.tonivade.purefun.typeclasses.Instances;
import com.github.tonivade.zeromock.api.HttpRequest;
import com.github.tonivade.zeromock.api.HttpResponse;
import com.github.tonivade.zeromock.api.HttpRouteBuilder;
import com.github.tonivade.zeromock.api.HttpServiceK;
import com.github.tonivade.zeromock.api.PostFilter;
import com.github.tonivade.zeromock.api.PreFilter;
import com.github.tonivade.zeromock.api.RequestHandler;
import java.util.Objects;

public final class HttpService
implements HttpRouteBuilder<HttpService> {
    private final HttpServiceK<Id<?>> serviceK;

    public HttpService(String name) {
        this(new HttpServiceK(name, Instances.monad((Kind[])new Id[0])));
    }

    private HttpService(HttpServiceK<Id<?>> serviceK) {
        this.serviceK = Objects.requireNonNull(serviceK);
    }

    public String name() {
        return this.serviceK.name();
    }

    public HttpServiceK<Id<?>> build() {
        return this.serviceK;
    }

    public HttpService mount(String path, HttpService other) {
        return new HttpService(this.serviceK.mount(path, other.serviceK));
    }

    public HttpService exec(RequestHandler handler) {
        return new HttpService(this.serviceK.exec(handler.lift(Instances.monad((Kind[])new Id[0]))));
    }

    public HttpRouteBuilder.ThenStep<HttpService> preFilter(Matcher1<HttpRequest> matcher) {
        return handler -> this.addPreFilter(matcher, handler);
    }

    public HttpService preFilter(PreFilter filter) {
        return new HttpService(this.serviceK.preFilter(filter.lift(Instances.monad((Kind[])new Id[0]))));
    }

    public HttpService postFilter(PostFilter filter) {
        return new HttpService(this.serviceK.postFilter(filter.lift(Instances.monad((Kind[])new Id[0]))));
    }

    @Override
    public HttpRouteBuilder.ThenStep<HttpService> when(Matcher1<HttpRequest> matcher) {
        return handler -> this.addMapping(matcher, handler);
    }

    public Option<HttpResponse> execute(HttpRequest request) {
        return (Option)((Id)this.serviceK.execute(request).fix(IdOf::toId)).value();
    }

    public HttpService combine(HttpService other) {
        return new HttpService(this.serviceK.combine(other.serviceK));
    }

    private HttpService addMapping(Matcher1<HttpRequest> matcher, RequestHandler handler) {
        return new HttpService(this.serviceK.addMapping(matcher, handler.lift(Instances.monad((Kind[])new Id[0]))));
    }

    private HttpService addPreFilter(Matcher1<HttpRequest> matcher, RequestHandler handler) {
        return this.preFilter(PreFilter.filter(matcher, handler));
    }

    public String toString() {
        return "HttpService(" + this.serviceK.name() + ")";
    }
}

