/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.zeromock.api;

import com.github.tonivade.purefun.Kind;
import com.github.tonivade.purefun.core.Function1;
import com.github.tonivade.purefun.core.Matcher1;
import com.github.tonivade.purefun.core.PartialFunction1;
import com.github.tonivade.purefun.core.Precondition;
import com.github.tonivade.purefun.type.Either;
import com.github.tonivade.purefun.type.Option;
import com.github.tonivade.purefun.type.OptionOf;
import com.github.tonivade.purefun.typeclasses.For;
import com.github.tonivade.purefun.typeclasses.Instances;
import com.github.tonivade.purefun.typeclasses.Monad;
import com.github.tonivade.zeromock.api.HttpRequest;
import com.github.tonivade.zeromock.api.HttpResponse;
import com.github.tonivade.zeromock.api.HttpRouteBuilderK;
import com.github.tonivade.zeromock.api.Matchers;
import com.github.tonivade.zeromock.api.PostFilterK;
import com.github.tonivade.zeromock.api.PreFilterK;
import com.github.tonivade.zeromock.api.RequestHandlerK;
import com.github.tonivade.zeromock.api.Responses;

public final class HttpServiceK<F extends Kind<F, ?>>
implements HttpRouteBuilderK<F, HttpServiceK<F>> {
    private final String name;
    private final Monad<F> monad;
    private final PartialFunction1<HttpRequest, Kind<F, HttpResponse>> mappings;
    private final Function1<HttpRequest, Kind<F, Either<HttpResponse, HttpRequest>>> preFilters;
    private final Function1<HttpResponse, Kind<F, HttpResponse>> postFilters;

    public HttpServiceK(String name, Monad<F> monad) {
        this(name, monad, PartialFunction1.of((Matcher1)Matcher1.never(), (Function1)Function1.fail(IllegalStateException::new)), request -> monad.pure((Object)Either.right((Object)request)), arg_0 -> monad.pure(arg_0));
    }

    private HttpServiceK(String name, Monad<F> monad, PartialFunction1<HttpRequest, Kind<F, HttpResponse>> mappings, Function1<HttpRequest, Kind<F, Either<HttpResponse, HttpRequest>>> preFilters, Function1<HttpResponse, Kind<F, HttpResponse>> postFilters) {
        this.name = (String)Precondition.checkNonNull((Object)name);
        this.monad = (Monad)Precondition.checkNonNull(monad);
        this.mappings = (PartialFunction1)Precondition.checkNonNull(mappings);
        this.preFilters = (Function1)Precondition.checkNonNull(preFilters);
        this.postFilters = (Function1)Precondition.checkNonNull(postFilters);
    }

    public String name() {
        return this.name;
    }

    Monad<F> monad() {
        return this.monad;
    }

    public HttpServiceK<F> mount(String path, HttpServiceK<F> other) {
        Precondition.checkNonNull((Object)path);
        Precondition.checkNonNull(other);
        return this.addMapping((Matcher1<HttpRequest>)Matchers.startsWith(path).and(req -> other.mappings.isDefinedAt((Object)req.dropOneLevel())), req -> this.monad.map(other.execute(req.dropOneLevel()), option -> (HttpResponse)option.getOrElse((Object)Responses.notFound())));
    }

    public HttpServiceK<F> exec(RequestHandlerK<F> handler) {
        return this.addMapping(Matchers.all(), handler);
    }

    @Override
    public HttpRouteBuilderK.ThenStepK<F, HttpServiceK<F>> when(Matcher1<HttpRequest> matcher) {
        return new HttpRouteBuilderK.ThenStepK(this.monad, handler -> this.addMapping(matcher, (RequestHandlerK<F>)handler));
    }

    public HttpRouteBuilderK.ThenStepK<F, HttpServiceK<F>> preFilter(Matcher1<HttpRequest> matcher) {
        return new HttpRouteBuilderK.ThenStepK(this.monad, handler -> this.addPreFilter(matcher, (RequestHandlerK<F>)handler));
    }

    public HttpServiceK<F> preFilter(PreFilterK<F> filter) {
        return this.addPreFilter((PreFilterK)Precondition.checkNonNull(filter));
    }

    public HttpServiceK<F> postFilter(PostFilterK<F> filter) {
        return this.addPostFilter((PostFilterK)Precondition.checkNonNull(filter));
    }

    public Kind<F, Option<HttpResponse>> execute(HttpRequest request) {
        Function1 mappingsWithPostFilters = this.mappings.andThen(value -> this.monad.flatMap(value, arg_0 -> this.postFilters.apply(arg_0))).lift();
        return For.with(this.monad).then((Kind)this.preFilters.apply((Object)request)).flatMap(either -> (Kind)either.fold(res -> this.monad.pure((Object)Option.some((Object)res)), mappingsWithPostFilters.andThen(option -> Instances.traverse((Kind[])new Option[0]).sequence(this.monad, (Kind)option)))).map(OptionOf::toOption).run();
    }

    public HttpServiceK<F> combine(HttpServiceK<F> other) {
        Precondition.checkNonNull(other);
        return new HttpServiceK<F>(this.name + "+" + other.name, this.monad, this.mappings.orElse(other.mappings), this.preFilters.andThen(value -> this.monad.flatMap(value, either -> (Kind)either.fold(response -> this.monad.pure((Object)Either.left((Object)response)), other.preFilters))), arg_0 -> ((Function1)this.postFilters.andThen(value -> this.monad.flatMap(value, other.postFilters))).apply(arg_0));
    }

    public HttpServiceK<F> addMapping(Matcher1<HttpRequest> matcher, RequestHandlerK<F> handler) {
        Precondition.checkNonNull(matcher);
        Precondition.checkNonNull(handler);
        return new HttpServiceK<F>(this.name, this.monad, this.mappings.orElse(PartialFunction1.of(matcher, arg_0 -> handler.apply(arg_0))), this.preFilters, this.postFilters);
    }

    public HttpServiceK<F> addPreFilter(Matcher1<HttpRequest> matcher, RequestHandlerK<F> handler) {
        return this.addPreFilter(PreFilterK.filter(this.monad, matcher, handler));
    }

    private HttpServiceK<F> addPreFilter(PreFilterK<F> filter) {
        Precondition.checkNonNull(filter);
        return new HttpServiceK<F>(this.name, this.monad, this.mappings, this.preFilters.andThen(value -> this.monad.flatMap(value, either -> (Kind)either.fold(response -> this.monad.pure((Object)Either.left((Object)response)), (Function1)filter))), this.postFilters);
    }

    private HttpServiceK<F> addPostFilter(PostFilterK<F> filter) {
        Precondition.checkNonNull(filter);
        return new HttpServiceK<F>(this.name, this.monad, this.mappings, this.preFilters, arg_0 -> ((Function1)this.postFilters.andThen(value -> this.monad.flatMap(value, (Function1)filter))).apply(arg_0));
    }
}

