/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.zeromock.api;

import com.github.tonivade.purefun.Kind;
import com.github.tonivade.purefun.core.Matcher1;
import com.github.tonivade.purefun.effect.UIO;
import com.github.tonivade.purefun.effect.UIOOf;
import com.github.tonivade.purefun.type.Option;
import com.github.tonivade.purefun.typeclasses.Instances;
import com.github.tonivade.zeromock.api.HttpRequest;
import com.github.tonivade.zeromock.api.HttpResponse;
import com.github.tonivade.zeromock.api.HttpRouteBuilderK;
import com.github.tonivade.zeromock.api.HttpServiceK;
import com.github.tonivade.zeromock.api.PostFilter;
import com.github.tonivade.zeromock.api.PostFilterK;
import com.github.tonivade.zeromock.api.PreFilter;
import com.github.tonivade.zeromock.api.PreFilterK;
import com.github.tonivade.zeromock.api.RequestHandlerK;
import java.util.Objects;

public final class HttpUIOService
implements HttpRouteBuilderK<UIO<?>, HttpUIOService> {
    private final HttpServiceK<UIO<?>> serviceK;

    public HttpUIOService(String name) {
        this(new HttpServiceK(name, Instances.monad((Kind[])new UIO[0])));
    }

    private HttpUIOService(HttpServiceK<UIO<?>> serviceK) {
        this.serviceK = Objects.requireNonNull(serviceK);
    }

    public String name() {
        return this.serviceK.name();
    }

    public HttpUIOService mount(String path, HttpUIOService other) {
        return new HttpUIOService(this.serviceK.mount(path, other.serviceK));
    }

    public HttpUIOService exec(RequestHandlerK<UIO<?>> handler) {
        return new HttpUIOService(this.serviceK.exec(handler));
    }

    public HttpRouteBuilderK.ThenStepK<UIO<?>, HttpUIOService> preFilter(Matcher1<HttpRequest> matcher) {
        return new HttpRouteBuilderK.ThenStepK(this.serviceK.monad(), handler -> this.addPreFilter(matcher, (RequestHandlerK<UIO<?>>)handler));
    }

    public HttpUIOService preFilter(PreFilter filter) {
        return this.preFilter(filter.lift(this.serviceK.monad()));
    }

    public HttpUIOService preFilter(PreFilterK<UIO<?>> filter) {
        return new HttpUIOService(this.serviceK.preFilter(filter));
    }

    public HttpUIOService postFilter(PostFilter filter) {
        return this.postFilter(filter.lift(this.serviceK.monad()));
    }

    public HttpUIOService postFilter(PostFilterK<UIO<?>> filter) {
        return new HttpUIOService(this.serviceK.postFilter(filter));
    }

    @Override
    public HttpRouteBuilderK.ThenStepK<UIO<?>, HttpUIOService> when(Matcher1<HttpRequest> matcher) {
        return new HttpRouteBuilderK.ThenStepK(this.serviceK.monad(), handler -> this.addMapping(matcher, (RequestHandlerK<UIO<?>>)handler));
    }

    public UIO<Option<HttpResponse>> execute(HttpRequest request) {
        return (UIO)this.serviceK.execute(request).fix(UIOOf::toUIO);
    }

    public HttpUIOService combine(HttpUIOService other) {
        return new HttpUIOService(this.serviceK.combine(other.serviceK));
    }

    public HttpServiceK<UIO<?>> build() {
        return this.serviceK;
    }

    private HttpUIOService addMapping(Matcher1<HttpRequest> matcher, RequestHandlerK<UIO<?>> handler) {
        return new HttpUIOService(this.serviceK.addMapping(matcher, handler));
    }

    private HttpUIOService addPreFilter(Matcher1<HttpRequest> matcher, RequestHandlerK<UIO<?>> handler) {
        return this.preFilter(PreFilterK.filter(this.serviceK.monad(), matcher, handler));
    }

    public String toString() {
        return "HttpUIOService(" + this.serviceK.name() + ")";
    }
}

