/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.zeromock.api;

import com.github.tonivade.purefun.Kind;
import com.github.tonivade.purefun.core.Matcher1;
import com.github.tonivade.purefun.effect.URIO;
import com.github.tonivade.purefun.effect.URIOOf;
import com.github.tonivade.purefun.type.Option;
import com.github.tonivade.purefun.typeclasses.Instances;
import com.github.tonivade.zeromock.api.HttpRequest;
import com.github.tonivade.zeromock.api.HttpResponse;
import com.github.tonivade.zeromock.api.HttpRouteBuilderK;
import com.github.tonivade.zeromock.api.HttpServiceK;
import com.github.tonivade.zeromock.api.PostFilter;
import com.github.tonivade.zeromock.api.PostFilterK;
import com.github.tonivade.zeromock.api.PreFilter;
import com.github.tonivade.zeromock.api.PreFilterK;
import com.github.tonivade.zeromock.api.RequestHandlerK;
import java.util.Objects;

public final class HttpURIOService<R>
implements HttpRouteBuilderK<URIO<R, ?>, HttpURIOService<R>> {
    private final HttpServiceK<URIO<R, ?>> serviceK;

    public HttpURIOService(String name) {
        this(new HttpServiceK(name, Instances.monad((Kind[])new URIO[0])));
    }

    private HttpURIOService(HttpServiceK<URIO<R, ?>> serviceK) {
        this.serviceK = Objects.requireNonNull(serviceK);
    }

    public String name() {
        return this.serviceK.name();
    }

    public HttpURIOService<R> mount(String path, HttpURIOService<R> other) {
        return new HttpURIOService<R>(this.serviceK.mount(path, other.serviceK));
    }

    public HttpURIOService<R> exec(RequestHandlerK<URIO<R, ?>> handler) {
        return new HttpURIOService<R>(this.serviceK.exec(handler));
    }

    public HttpRouteBuilderK.ThenStepK<URIO<R, ?>, HttpURIOService<R>> preFilter(Matcher1<HttpRequest> matcher) {
        return new HttpRouteBuilderK.ThenStepK(this.serviceK.monad(), handler -> this.addPreFilter(matcher, (RequestHandlerK<URIO<R, ?>>)handler));
    }

    public HttpURIOService<R> preFilter(PreFilter filter) {
        return this.preFilter(filter.lift(this.serviceK.monad()));
    }

    public HttpURIOService<R> preFilter(PreFilterK<URIO<R, ?>> filter) {
        return new HttpURIOService<R>(this.serviceK.preFilter(filter));
    }

    public HttpURIOService<R> postFilter(PostFilter filter) {
        return this.postFilter(filter.lift(this.serviceK.monad()));
    }

    public HttpURIOService<R> postFilter(PostFilterK<URIO<R, ?>> filter) {
        return new HttpURIOService<R>(this.serviceK.postFilter(filter));
    }

    @Override
    public HttpRouteBuilderK.ThenStepK<URIO<R, ?>, HttpURIOService<R>> when(Matcher1<HttpRequest> matcher) {
        return new HttpRouteBuilderK.ThenStepK(this.serviceK.monad(), handler -> this.addMapping(matcher, (RequestHandlerK<URIO<R, ?>>)handler));
    }

    public URIO<R, Option<HttpResponse>> execute(HttpRequest request) {
        return (URIO)this.serviceK.execute(request).fix(URIOOf::toURIO);
    }

    public HttpURIOService<R> combine(HttpURIOService<R> other) {
        return new HttpURIOService<R>(this.serviceK.combine(other.serviceK));
    }

    public HttpServiceK<URIO<R, ?>> build() {
        return this.serviceK;
    }

    private HttpURIOService<R> addMapping(Matcher1<HttpRequest> matcher, RequestHandlerK<URIO<R, ?>> handler) {
        return new HttpURIOService<R>(this.serviceK.addMapping(matcher, handler));
    }

    private HttpURIOService<R> addPreFilter(Matcher1<HttpRequest> matcher, RequestHandlerK<URIO<R, ?>> handler) {
        return this.preFilter(PreFilterK.filter(this.serviceK.monad(), matcher, handler));
    }

    public String toString() {
        return "HttpURIOService(" + this.serviceK.name() + ")";
    }
}

