/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.zeromock.api;

import com.github.tonivade.purefun.core.Function1;
import com.github.tonivade.purefun.core.Matcher1;
import com.github.tonivade.purefun.data.ImmutableSet;
import com.github.tonivade.purejson.JsonNode;
import com.github.tonivade.purejson.PureJson;
import com.github.tonivade.zeromock.api.Bytes;
import com.github.tonivade.zeromock.api.Extractors;
import com.github.tonivade.zeromock.api.HttpMethod;
import com.github.tonivade.zeromock.api.HttpPath;
import com.github.tonivade.zeromock.api.HttpRequest;

public final class Matchers {
    private Matchers() {
    }

    public static Matcher1<HttpRequest> all() {
        return request -> true;
    }

    public static Matcher1<HttpRequest> method(HttpMethod method) {
        return request -> request.method().equals((Object)method);
    }

    public static Matcher1<HttpRequest> path(String url) {
        return request -> request.path().match(HttpPath.from(url));
    }

    public static Matcher1<HttpRequest> startsWith(String url) {
        return request -> request.path().startsWith(HttpPath.from(url));
    }

    public static Matcher1<HttpRequest> param(String name) {
        return request -> request.params().contains(name);
    }

    public static Matcher1<HttpRequest> param(String name, String value) {
        return request -> (Boolean)request.params().get(name).map(value::equals).getOrElse((Object)false);
    }

    public static Matcher1<HttpRequest> header(String key) {
        return request -> request.headers().contains(key);
    }

    public static Matcher1<HttpRequest> header(String key, String value) {
        return Matchers.header(key, (Matcher1<ImmutableSet<String>>)((Matcher1)values -> values.contains((Object)value)));
    }

    public static Matcher1<HttpRequest> header(String key, Matcher1<ImmutableSet<String>> matcher) {
        return Matchers.header(key).and(request -> matcher.match(request.headers().get(key)));
    }

    public static Matcher1<HttpRequest> get() {
        return Matchers.method(HttpMethod.GET);
    }

    public static Matcher1<HttpRequest> put() {
        return Matchers.method(HttpMethod.PUT);
    }

    public static Matcher1<HttpRequest> post() {
        return Matchers.method(HttpMethod.POST);
    }

    public static Matcher1<HttpRequest> delete() {
        return Matchers.method(HttpMethod.DELETE);
    }

    public static Matcher1<HttpRequest> patch() {
        return Matchers.method(HttpMethod.PATCH);
    }

    public static Matcher1<HttpRequest> head() {
        return Matchers.method(HttpMethod.HEAD);
    }

    public static Matcher1<HttpRequest> options() {
        return Matchers.method(HttpMethod.OPTIONS);
    }

    public static <T> Matcher1<HttpRequest> equalTo(T value) {
        return arg_0 -> ((Function1)Extractors.jsonTo(value.getClass()).andThen(value::equals)).apply(arg_0);
    }

    public static <T> Matcher1<HttpRequest> jsonPath(String jsonPath, Matcher1<T> matcher) {
        return arg_0 -> ((Function1)Extractors.extract(jsonPath).andThen(arg_0 -> matcher.match(arg_0))).apply(arg_0);
    }

    public static Matcher1<HttpRequest> body(String body) {
        return request -> Bytes.asString(request.body()).equals(body);
    }

    public static Matcher1<HttpRequest> json(String body) {
        return request -> {
            JsonNode expected = (JsonNode)PureJson.parse((String)body).getOrElseThrow();
            return Matchers.toJson(request.body()).equals((Object)expected);
        };
    }

    private static JsonNode toJson(Bytes bytes) {
        String content = Bytes.asString(bytes);
        return (JsonNode)PureJson.parse((String)content).getOrElseThrow();
    }

    public static Matcher1<HttpRequest> accept(String contentType) {
        return Matchers.header("Accept", contentType);
    }

    public static Matcher1<HttpRequest> acceptsXml() {
        return Matchers.accept("text/xml");
    }

    public static Matcher1<HttpRequest> acceptsJson() {
        return Matchers.accept("application/json");
    }

    public static Matcher1<HttpRequest> get(String path) {
        return Matchers.get().and(Matchers.path(path));
    }

    public static Matcher1<HttpRequest> put(String path) {
        return Matchers.put().and(Matchers.path(path));
    }

    public static Matcher1<HttpRequest> post(String path) {
        return Matchers.post().and(Matchers.path(path));
    }

    public static Matcher1<HttpRequest> patch(String path) {
        return Matchers.patch().and(Matchers.path(path));
    }

    public static Matcher1<HttpRequest> delete(String path) {
        return Matchers.delete().and(Matchers.path(path));
    }

    public static Matcher1<HttpRequest> head(String path) {
        return Matchers.head().and(Matchers.path(path));
    }

    public static Matcher1<HttpRequest> options(String path) {
        return Matchers.options().and(Matchers.path(path));
    }
}

