/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.zeromock.api;

import com.github.tonivade.purefun.Kind;
import com.github.tonivade.purefun.core.Consumer2;
import com.github.tonivade.purefun.core.Function1;
import com.github.tonivade.purefun.core.Matcher1;
import com.github.tonivade.purefun.type.Either;
import com.github.tonivade.purefun.typeclasses.Monad;
import com.github.tonivade.zeromock.api.Bytes;
import com.github.tonivade.zeromock.api.HttpRequest;
import com.github.tonivade.zeromock.api.HttpResponse;
import com.github.tonivade.zeromock.api.PreFilterK;
import com.github.tonivade.zeromock.api.RequestHandler;
import com.github.tonivade.zeromock.api.Responses;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;

public interface PreFilter
extends Function1<HttpRequest, Either<HttpResponse, HttpRequest>> {
    public static PreFilter delay(Duration duration) {
        return request -> {
            Thread.sleep(duration);
            return Either.right((Object)request);
        };
    }

    public static PreFilter fail(AtomicInteger times) {
        return request -> {
            if (times.decrementAndGet() >= 0) {
                return Either.left((Object)Responses.error());
            }
            return Either.right((Object)request);
        };
    }

    default public <F extends Kind<F, ?>> PreFilterK<F> lift(Monad<F> monad) {
        return arg_0 -> ((Function1)this.andThen(arg_0 -> monad.pure(arg_0))).apply(arg_0);
    }

    public static PreFilter filter(Matcher1<HttpRequest> matcher, RequestHandler handler) {
        return request -> matcher.match(request) ? Either.left((Object)((HttpResponse)handler.apply(request))) : Either.right((Object)request);
    }

    public static PreFilter print(PrintStream output) {
        return PreFilter.print(new PrintWriter((Writer)new OutputStreamWriter((OutputStream)output, StandardCharsets.UTF_8), true));
    }

    public static PreFilter print(PrintWriter output) {
        return request -> {
            output.println(new Date());
            output.println(String.valueOf((Object)request.method()) + " " + request.path().toPath() + request.params().toQueryString());
            request.headers().forEach((Consumer2<String, String>)((Consumer2)(name, value) -> output.println(name + ":" + value)));
            output.println();
            output.println(Bytes.asString(request.body()));
            return Either.right((Object)request);
        };
    }
}

