/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.zeromock.api;

import com.github.tonivade.purefun.core.Function1;
import com.github.tonivade.purefun.type.Try;
import com.github.tonivade.purejson.JsonDSL;
import com.github.tonivade.purejson.JsonNode;
import com.github.tonivade.purejson.PureJson;
import com.github.tonivade.zeromock.api.Bytes;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.stream.Stream;

public final class Serializers {
    private Serializers() {
    }

    public static <T> Function1<T, Try<Bytes>> empty() {
        return value -> Try.success((Object)Bytes.empty());
    }

    public static Function1<Throwable, Try<Bytes>> throwableToJson() {
        return Serializers.toJson(Serializers::toJson);
    }

    @SafeVarargs
    public static <T> Function1<T, Try<Bytes>> objectToJson(T ... reified) {
        return Serializers.objectToJson(Serializers.getClassOf(reified));
    }

    public static <T> Function1<T, Try<Bytes>> objectToJson(Type type) {
        return Serializers.toJson(value -> Serializers.toJson(value, type));
    }

    public static <T> Function1<T, Try<Bytes>> objectToJson(Function1<T, String> serializer) {
        return Serializers.toJson(serializer.liftTry());
    }

    public static <T> Function1<T, Try<Bytes>> objectToXml() {
        return Serializers.objectToXml(Serializers::toXml);
    }

    public static <T> Function1<T, Try<Bytes>> objectToXml(Function1<T, String> serializer) {
        return Serializers.toXml(serializer.liftTry());
    }

    public static <T> Function1<T, Bytes> plain() {
        return value -> Bytes.asBytes(value.toString());
    }

    private static Try<String> toJson(Throwable error) {
        return PureJson.serialize((JsonNode)Serializers.throwableToJson(error));
    }

    private static <T> Try<String> toJson(T value, Type type) {
        return new PureJson(type).toString(value);
    }

    private static <T> Function1<T, Try<Bytes>> toJson(Function1<T, Try<String>> serializer) {
        return serializer.andThen(string -> string.map(Bytes::asBytes));
    }

    private static <T> Function1<T, Try<Bytes>> toXml(Function1<T, Try<String>> serializer) {
        return serializer.andThen(string -> string.map(Bytes::asBytes));
    }

    private static <T> String toXml(T value) {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{value.getClass()});
            StringWriter writer = new StringWriter();
            Marshaller marshaller = context.createMarshaller();
            marshaller.marshal(value, (Writer)writer);
            return writer.toString();
        }
        catch (JAXBException e) {
            throw new UncheckedIOException(new IOException(e));
        }
    }

    private static JsonNode throwableToJson(Throwable error) {
        return JsonDSL.object((JsonNode.Tuple[])new JsonNode.Tuple[]{JsonDSL.entry((String)"type", (JsonNode)JsonDSL.string((String)error.getClass().getName())), JsonDSL.entry((String)"message", (JsonNode)(error.getMessage() != null ? JsonDSL.string((String)error.getMessage()) : JsonNode.NULL)), JsonDSL.entry((String)"trace", (JsonNode)Serializers.stacktrace(error.getStackTrace()))});
    }

    private static JsonNode stacktrace(StackTraceElement[] stackTrace) {
        return JsonDSL.array((JsonNode[])((JsonNode[])Stream.of(stackTrace).map(Object::toString).map(JsonDSL::string).toArray(JsonNode[]::new)));
    }

    private static <T> Class<T> getClassOf(T ... reified) {
        if (reified.length > 0) {
            throw new IllegalArgumentException("do not pass arguments to this function, it's just a trick to get refied types");
        }
        return reified.getClass().getComponentType();
    }
}

