/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.zeromock.junit5;

import com.github.tonivade.purefun.Nullable;
import com.github.tonivade.purefun.core.Tuple;
import com.github.tonivade.purefun.core.Tuple2;
import com.github.tonivade.zeromock.client.AsyncHttpClient;
import com.github.tonivade.zeromock.client.HttpClient;
import com.github.tonivade.zeromock.client.HttpClientBuilder;
import com.github.tonivade.zeromock.client.IOHttpClient;
import com.github.tonivade.zeromock.client.TaskHttpClient;
import com.github.tonivade.zeromock.client.UIOHttpClient;
import com.github.tonivade.zeromock.junit5.ListenAt;
import com.github.tonivade.zeromock.junit5.Mount;
import com.github.tonivade.zeromock.server.AsyncMockHttpServer;
import com.github.tonivade.zeromock.server.HttpServer;
import com.github.tonivade.zeromock.server.IOMockHttpServer;
import com.github.tonivade.zeromock.server.MockHttpServer;
import com.github.tonivade.zeromock.server.MockHttpServerK;
import com.github.tonivade.zeromock.server.UIOMockHttpServer;
import com.github.tonivade.zeromock.server.URIOMockHttpServer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;

public class MockHttpServerExtension
implements BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback,
AfterEachCallback,
ParameterResolver {
    private com.sun.net.httpserver.HttpServer server;
    @Nullable
    private HttpServer serverK;

    public void beforeAll(ExtensionContext context) {
        Optional<ListenAt> listenAt = MockHttpServerExtension.listenAt(context);
        int port = listenAt.map(ListenAt::value).orElse(0);
        this.server = new MockHttpServerK.Builder().port(port).build();
        this.server.start();
    }

    public void beforeEach(ExtensionContext context) {
        try {
            this.server.removeContext("/");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        finally {
            this.serverK = null;
        }
    }

    public void afterEach(ExtensionContext context) {
        if (this.serverK != null && !this.serverK.getUnmatched().isEmpty()) {
            context.publishReportEntry("UnmatchedRequests", this.unmatched());
        }
    }

    public void afterAll(ExtensionContext context) {
        this.server.stop(0);
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        Class<?> type = parameterContext.getParameter().getType();
        return MockHttpServerExtension.serverInstance(type) || MockHttpServerExtension.clientInstance(type);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        Class<?> type = parameterContext.getParameter().getType();
        if (MockHttpServerExtension.serverInstance(type)) {
            List<Tuple2<Field, Mount>> services = this.findServices(extensionContext);
            HttpServer server = this.buildServer(type);
            this.mount(extensionContext, server, services);
            return server;
        }
        if (MockHttpServerExtension.clientInstance(type)) {
            String baseUrl = "http://localhost:" + this.server.getAddress().getPort();
            return this.buildClient(type).connectTo(baseUrl);
        }
        throw new ParameterResolutionException("invalid param");
    }

    private void mount(ExtensionContext context, HttpServer server, List<Tuple2<Field, Mount>> services) {
        Optional<Method> mountMethod = Stream.of(server.getClass().getDeclaredMethods()).filter(m -> m.getName().equals("mount")).findFirst();
        services.forEach(t -> mountMethod.ifPresent(m -> {
            Field field = (Field)t.get1();
            field.trySetAccessible();
            Mount mount = (Mount)t.get2();
            try {
                m.invoke((Object)server, mount.value(), field.get(context.getRequiredTestInstance()));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new ParameterResolutionException("cannot access field " + field.getName());
            }
            catch (InvocationTargetException e) {
                throw new ParameterResolutionException("cannot execute method " + m.getName());
            }
        }));
    }

    private List<Tuple2<Field, Mount>> findServices(ExtensionContext extensionContext) {
        Optional testClass = extensionContext.getTestClass();
        return testClass.map(Class::getDeclaredFields).stream().flatMap(Stream::of).map(f -> Tuple.of((Object)f, (Object)f.getAnnotation(Mount.class))).filter(t -> t.get2() != null).toList();
    }

    private HttpServer buildServer(Class<?> type) {
        if (type.isAssignableFrom(MockHttpServer.class)) {
            this.serverK = new MockHttpServer(this.server);
        } else if (type.isAssignableFrom(AsyncMockHttpServer.class)) {
            this.serverK = new AsyncMockHttpServer(this.server);
        } else if (type.isAssignableFrom(IOMockHttpServer.class)) {
            this.serverK = new IOMockHttpServer(this.server);
        } else if (type.isAssignableFrom(UIOMockHttpServer.class)) {
            this.serverK = new UIOMockHttpServer(this.server);
        } else {
            if (type.isAssignableFrom(URIOMockHttpServer.class)) {
                throw new UnsupportedOperationException("urio is not supported yet!");
            }
            throw new ParameterResolutionException("invalid server param");
        }
        return this.serverK;
    }

    private HttpClientBuilder<?> buildClient(Class<?> type) {
        if (type.isAssignableFrom(HttpClient.class)) {
            return HttpClientBuilder.client();
        }
        if (type.isAssignableFrom(AsyncHttpClient.class)) {
            return HttpClientBuilder.asyncClient();
        }
        if (type.isAssignableFrom(IOHttpClient.class)) {
            return HttpClientBuilder.ioClient();
        }
        if (type.isAssignableFrom(UIOHttpClient.class)) {
            return HttpClientBuilder.uioClient();
        }
        if (type.isAssignableFrom(TaskHttpClient.class)) {
            return HttpClientBuilder.taskClient();
        }
        throw new ParameterResolutionException("invalid client param");
    }

    private String unmatched() {
        if (this.serverK == null) {
            return "";
        }
        return this.serverK.getUnmatched().join(",", "[", "]");
    }

    private static Optional<ListenAt> listenAt(ExtensionContext context) {
        return context.getTestClass().map(clazz -> clazz.getDeclaredAnnotation(ListenAt.class));
    }

    private static boolean serverInstance(Class<?> type) {
        return type.equals(MockHttpServer.class) || type.equals(AsyncMockHttpServer.class) || type.equals(IOMockHttpServer.class) || type.equals(UIOMockHttpServer.class) || type.equals(URIOMockHttpServer.class);
    }

    private static boolean clientInstance(Class<?> type) {
        return type.equals(HttpClient.class) || type.equals(AsyncHttpClient.class) || type.equals(IOHttpClient.class) || type.equals(UIOHttpClient.class) || type.equals(TaskHttpClient.class);
    }
}

