/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.zeromock.api;

import com.github.tonivade.purefun.Function1;
import com.github.tonivade.purefun.Function2;
import com.github.tonivade.purefun.Matcher1;
import com.github.tonivade.purefun.instances.IOInstances;
import com.github.tonivade.purefun.monad.IO;
import com.github.tonivade.purefun.monad.IOOf;
import com.github.tonivade.purefun.monad.IO_;
import com.github.tonivade.purefun.type.Option;
import com.github.tonivade.purefun.typeclasses.Monad;
import com.github.tonivade.zeromock.api.HttpRequest;
import com.github.tonivade.zeromock.api.HttpResponse;
import com.github.tonivade.zeromock.api.HttpServiceK;
import com.github.tonivade.zeromock.api.IOPostFilter;
import com.github.tonivade.zeromock.api.IOPreFilter;
import com.github.tonivade.zeromock.api.IORequestHandler;
import com.github.tonivade.zeromock.api.PostFilter;
import com.github.tonivade.zeromock.api.PostFilterK;
import com.github.tonivade.zeromock.api.PreFilter;
import com.github.tonivade.zeromock.api.PreFilterK;
import com.github.tonivade.zeromock.api.RequestHandlerK;
import java.util.Objects;

public final class HttpIOService {
    private final HttpServiceK<IO_> serviceK;

    public HttpIOService(String name) {
        this((HttpServiceK<IO_>)new HttpServiceK(name, IOInstances.monad()));
    }

    private HttpIOService(HttpServiceK<IO_> serviceK) {
        this.serviceK = Objects.requireNonNull(serviceK);
    }

    public String name() {
        return this.serviceK.name();
    }

    public HttpIOService mount(String path, HttpIOService other) {
        return new HttpIOService((HttpServiceK<IO_>)this.serviceK.mount(path, other.serviceK));
    }

    public HttpIOService exec(IORequestHandler handler) {
        return new HttpIOService((HttpServiceK<IO_>)this.serviceK.exec((RequestHandlerK)handler));
    }

    public MappingBuilder<HttpIOService> preFilter(Matcher1<HttpRequest> matcher) {
        return new MappingBuilder(this::addPreFilter).when(Objects.requireNonNull(matcher));
    }

    public HttpIOService preFilter(PreFilter filter) {
        return this.preFilter(arg_0 -> ((Function1)filter.andThen(IO::pure)).apply(arg_0));
    }

    public HttpIOService preFilter(IOPreFilter filter) {
        return new HttpIOService((HttpServiceK<IO_>)this.serviceK.preFilter((PreFilterK)filter));
    }

    public HttpIOService postFilter(PostFilter filter) {
        return this.postFilter(arg_0 -> ((Function1)filter.andThen(IO::pure)).apply(arg_0));
    }

    public HttpIOService postFilter(IOPostFilter filter) {
        return new HttpIOService((HttpServiceK<IO_>)this.serviceK.postFilter((PostFilterK)filter));
    }

    public MappingBuilder<HttpIOService> when(Matcher1<HttpRequest> matcher) {
        return new MappingBuilder(this::addMapping).when(matcher);
    }

    public IO<Option<HttpResponse>> execute(HttpRequest request) {
        return (IO)this.serviceK.execute(request).fix(IOOf::narrowK);
    }

    public HttpIOService combine(HttpIOService other) {
        return new HttpIOService((HttpServiceK<IO_>)this.serviceK.combine(other.serviceK));
    }

    public HttpServiceK<IO_> build() {
        return this.serviceK;
    }

    public HttpIOService addMapping(Matcher1<HttpRequest> matcher, IORequestHandler handler) {
        return new HttpIOService((HttpServiceK<IO_>)this.serviceK.addMapping(matcher, (RequestHandlerK)handler));
    }

    protected HttpIOService addPreFilter(Matcher1<HttpRequest> matcher, IORequestHandler handler) {
        return this.preFilter(arg_0 -> ((PreFilterK)PreFilterK.filter((Monad)IOInstances.monad(), matcher, (RequestHandlerK)handler)).apply(arg_0));
    }

    public String toString() {
        return "HttpIOService(" + this.serviceK.name() + ")";
    }

    public static final class MappingBuilder<T> {
        private final Function2<Matcher1<HttpRequest>, IORequestHandler, T> finisher;
        private Matcher1<HttpRequest> matcher;

        public MappingBuilder(Function2<Matcher1<HttpRequest>, IORequestHandler, T> finisher) {
            this.finisher = Objects.requireNonNull(finisher);
        }

        public MappingBuilder<T> when(Matcher1<HttpRequest> matcher) {
            this.matcher = matcher;
            return this;
        }

        public T then(IORequestHandler handler) {
            return (T)this.finisher.apply(this.matcher, (Object)handler);
        }
    }
}

