/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.zeromock.api;

import com.github.tonivade.purefun.Function1;
import com.github.tonivade.purefun.Function2;
import com.github.tonivade.purefun.Matcher1;
import com.github.tonivade.purefun.effect.UIO;
import com.github.tonivade.purefun.effect.UIOOf;
import com.github.tonivade.purefun.effect.UIO_;
import com.github.tonivade.purefun.instances.UIOInstances;
import com.github.tonivade.purefun.type.Option;
import com.github.tonivade.purefun.typeclasses.Monad;
import com.github.tonivade.zeromock.api.HttpRequest;
import com.github.tonivade.zeromock.api.HttpResponse;
import com.github.tonivade.zeromock.api.HttpServiceK;
import com.github.tonivade.zeromock.api.PostFilter;
import com.github.tonivade.zeromock.api.PostFilterK;
import com.github.tonivade.zeromock.api.PreFilter;
import com.github.tonivade.zeromock.api.PreFilterK;
import com.github.tonivade.zeromock.api.RequestHandlerK;
import com.github.tonivade.zeromock.api.UIOPostFilter;
import com.github.tonivade.zeromock.api.UIOPreFilter;
import com.github.tonivade.zeromock.api.UIORequestHandler;
import java.util.Objects;

public final class HttpUIOService {
    private final HttpServiceK<UIO_> serviceK;

    public HttpUIOService(String name) {
        this((HttpServiceK<UIO_>)new HttpServiceK(name, UIOInstances.monad()));
    }

    private HttpUIOService(HttpServiceK<UIO_> serviceK) {
        this.serviceK = Objects.requireNonNull(serviceK);
    }

    public String name() {
        return this.serviceK.name();
    }

    public HttpUIOService mount(String path, HttpUIOService other) {
        return new HttpUIOService((HttpServiceK<UIO_>)this.serviceK.mount(path, other.serviceK));
    }

    public HttpUIOService exec(UIORequestHandler handler) {
        return new HttpUIOService((HttpServiceK<UIO_>)this.serviceK.exec((RequestHandlerK)handler));
    }

    public MappingBuilder<HttpUIOService> preFilter(Matcher1<HttpRequest> matcher) {
        return new MappingBuilder(this::addPreFilter).when(Objects.requireNonNull(matcher));
    }

    public HttpUIOService preFilter(PreFilter filter) {
        return this.preFilter(arg_0 -> ((Function1)filter.andThen(UIO::pure)).apply(arg_0));
    }

    public HttpUIOService preFilter(UIOPreFilter filter) {
        return new HttpUIOService((HttpServiceK<UIO_>)this.serviceK.preFilter((PreFilterK)filter));
    }

    public HttpUIOService postFilter(PostFilter filter) {
        return this.postFilter(arg_0 -> ((Function1)filter.andThen(UIO::pure)).apply(arg_0));
    }

    public HttpUIOService postFilter(UIOPostFilter filter) {
        return new HttpUIOService((HttpServiceK<UIO_>)this.serviceK.postFilter((PostFilterK)filter));
    }

    public MappingBuilder<HttpUIOService> when(Matcher1<HttpRequest> matcher) {
        return new MappingBuilder(this::addMapping).when(matcher);
    }

    public UIO<Option<HttpResponse>> execute(HttpRequest request) {
        return (UIO)this.serviceK.execute(request).fix(UIOOf::narrowK);
    }

    public HttpUIOService combine(HttpUIOService other) {
        return new HttpUIOService((HttpServiceK<UIO_>)this.serviceK.combine(other.serviceK));
    }

    public HttpServiceK<UIO_> build() {
        return this.serviceK;
    }

    protected HttpUIOService addMapping(Matcher1<HttpRequest> matcher, UIORequestHandler handler) {
        return new HttpUIOService((HttpServiceK<UIO_>)this.serviceK.addMapping(matcher, (RequestHandlerK)handler));
    }

    protected HttpUIOService addPreFilter(Matcher1<HttpRequest> matcher, UIORequestHandler handler) {
        return this.preFilter(arg_0 -> ((PreFilterK)PreFilterK.filter((Monad)UIOInstances.monad(), matcher, (RequestHandlerK)handler)).apply(arg_0));
    }

    public String toString() {
        return "HttpUIOService(" + this.serviceK.name() + ")";
    }

    public static final class MappingBuilder<T> {
        private final Function2<Matcher1<HttpRequest>, UIORequestHandler, T> finisher;
        private Matcher1<HttpRequest> matcher;

        public MappingBuilder(Function2<Matcher1<HttpRequest>, UIORequestHandler, T> finisher) {
            this.finisher = Objects.requireNonNull(finisher);
        }

        public MappingBuilder<T> when(Matcher1<HttpRequest> matcher) {
            this.matcher = matcher;
            return this;
        }

        public T then(UIORequestHandler handler) {
            return (T)this.finisher.apply(this.matcher, (Object)handler);
        }
    }
}

