/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.zeromock.api;

import com.github.tonivade.purefun.Function1;
import com.github.tonivade.purefun.Function2;
import com.github.tonivade.purefun.Kind;
import com.github.tonivade.purefun.Matcher1;
import com.github.tonivade.purefun.Nothing;
import com.github.tonivade.purefun.effect.ZIO;
import com.github.tonivade.purefun.effect.ZIOOf;
import com.github.tonivade.purefun.effect.ZIO_;
import com.github.tonivade.purefun.instances.ZIOInstances;
import com.github.tonivade.purefun.type.Option;
import com.github.tonivade.purefun.typeclasses.Monad;
import com.github.tonivade.zeromock.api.HttpRequest;
import com.github.tonivade.zeromock.api.HttpResponse;
import com.github.tonivade.zeromock.api.HttpServiceK;
import com.github.tonivade.zeromock.api.PostFilter;
import com.github.tonivade.zeromock.api.PreFilter;
import com.github.tonivade.zeromock.api.PreFilterK;
import com.github.tonivade.zeromock.api.ZIOPostFilter;
import com.github.tonivade.zeromock.api.ZIOPreFilter;
import com.github.tonivade.zeromock.api.ZIORequestHandler;
import java.util.Objects;

public final class HttpZIOService<R> {
    private final HttpServiceK<Kind<Kind<ZIO_, R>, Nothing>> serviceK;

    public HttpZIOService(String name) {
        this(new HttpServiceK(name, ZIOInstances.monad()));
    }

    private HttpZIOService(HttpServiceK<Kind<Kind<ZIO_, R>, Nothing>> serviceK) {
        this.serviceK = Objects.requireNonNull(serviceK);
    }

    public String name() {
        return this.serviceK.name();
    }

    public HttpZIOService<R> mount(String path, HttpZIOService<R> other) {
        return new HttpZIOService<R>(this.serviceK.mount(path, other.serviceK));
    }

    public HttpZIOService<R> exec(ZIO<R, Nothing, HttpResponse> method) {
        return new HttpZIOService<R>(this.serviceK.exec(arg_0 -> ((Function1)Function1.cons(method)).apply(arg_0)));
    }

    public MappingBuilder<R, HttpZIOService<R>> preFilter(Matcher1<HttpRequest> matcher) {
        return new MappingBuilder(this::addPreFilter).when(Objects.requireNonNull(matcher));
    }

    public HttpZIOService<R> preFilter(PreFilter filter) {
        return this.preFilter(arg_0 -> ((Function1)filter.andThen(ZIO::pure)).apply(arg_0));
    }

    public HttpZIOService<R> preFilter(ZIOPreFilter<R> filter) {
        return new HttpZIOService<R>(this.serviceK.preFilter(filter));
    }

    public HttpZIOService<R> postFilter(PostFilter filter) {
        return this.postFilter(arg_0 -> ((Function1)filter.andThen(ZIO::pure)).apply(arg_0));
    }

    public HttpZIOService<R> postFilter(ZIOPostFilter<R> filter) {
        return new HttpZIOService<R>(this.serviceK.postFilter(filter));
    }

    public MappingBuilder<R, HttpZIOService<R>> when(Matcher1<HttpRequest> matcher) {
        return new MappingBuilder(this::addMapping).when(matcher);
    }

    public ZIO<R, Nothing, Option<HttpResponse>> execute(HttpRequest request) {
        return (ZIO)this.serviceK.execute(request).fix(ZIOOf::narrowK);
    }

    public HttpZIOService<R> combine(HttpZIOService<R> other) {
        return new HttpZIOService<R>(this.serviceK.combine(other.serviceK));
    }

    public HttpServiceK<Kind<Kind<ZIO_, R>, Nothing>> build() {
        return this.serviceK;
    }

    protected HttpZIOService<R> addMapping(Matcher1<HttpRequest> matcher, ZIORequestHandler<R> handler) {
        return new HttpZIOService<R>(this.serviceK.addMapping(matcher, handler));
    }

    protected HttpZIOService<R> addPreFilter(Matcher1<HttpRequest> matcher, ZIORequestHandler<R> handler) {
        return this.preFilter(arg_0 -> ((PreFilterK)PreFilterK.filter((Monad)ZIOInstances.monad(), matcher, handler)).apply(arg_0));
    }

    public String toString() {
        return "HttpZIOService(" + this.serviceK.name() + ")";
    }

    public static final class MappingBuilder<R, T> {
        private final Function2<Matcher1<HttpRequest>, ZIORequestHandler<R>, T> finisher;
        private Matcher1<HttpRequest> matcher;

        public MappingBuilder(Function2<Matcher1<HttpRequest>, ZIORequestHandler<R>, T> finisher) {
            this.finisher = Objects.requireNonNull(finisher);
        }

        public MappingBuilder<R, T> when(Matcher1<HttpRequest> matcher) {
            this.matcher = matcher;
            return this;
        }

        public T then(ZIORequestHandler<R> handler) {
            return (T)this.finisher.apply(this.matcher, handler);
        }
    }
}

