/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.zeromock.server;

import com.github.tonivade.purefun.Function1;
import com.github.tonivade.purefun.Matcher1;
import com.github.tonivade.purefun.concurrent.Future;
import com.github.tonivade.purefun.concurrent.Future_;
import com.github.tonivade.purefun.instances.FutureInstances;
import com.github.tonivade.purefun.typeclasses.Monad;
import com.github.tonivade.zeromock.api.AsyncHttpService;
import com.github.tonivade.zeromock.api.AsyncPostFilter;
import com.github.tonivade.zeromock.api.AsyncPreFilter;
import com.github.tonivade.zeromock.api.AsyncRequestHandler;
import com.github.tonivade.zeromock.api.HttpRequest;
import com.github.tonivade.zeromock.api.HttpServiceK;
import com.github.tonivade.zeromock.api.PostFilter;
import com.github.tonivade.zeromock.api.PostFilterK;
import com.github.tonivade.zeromock.api.PreFilter;
import com.github.tonivade.zeromock.api.PreFilterK;
import com.github.tonivade.zeromock.api.RequestHandlerK;
import com.github.tonivade.zeromock.server.HttpServer;
import com.github.tonivade.zeromock.server.MockHttpServerK;
import com.github.tonivade.zeromock.server.ResponseInterpreterK;
import java.util.List;
import java.util.Objects;

public final class AsyncMockHttpServer
implements HttpServer {
    private final MockHttpServerK<Future_> serverK;

    public AsyncMockHttpServer(com.sun.net.httpserver.HttpServer server) {
        this(new MockHttpServerK<Future_>(server, FutureInstances.monad(), ResponseInterpreterK.async()));
    }

    private AsyncMockHttpServer(MockHttpServerK<Future_> serverK) {
        this.serverK = Objects.requireNonNull(serverK);
    }

    @Override
    public int getPort() {
        return this.serverK.getPort();
    }

    @Override
    public String getPath() {
        return this.serverK.getPath();
    }

    public static MockHttpServerK.BuilderK<Future_> builder() {
        return new MockHttpServerK.BuilderK<Future_>(FutureInstances.monad(), ResponseInterpreterK.async());
    }

    public static AsyncMockHttpServer listenAt(int port) {
        return new AsyncMockHttpServer(AsyncMockHttpServer.builder().port(port).build());
    }

    public AsyncMockHttpServer mount(String path, AsyncHttpService other) {
        this.serverK.mount(path, (HttpServiceK<Future_>)other.build());
        return this;
    }

    public AsyncMockHttpServer exec(AsyncRequestHandler handler) {
        this.serverK.exec((RequestHandlerK<Future_>)handler);
        return this;
    }

    public AsyncHttpService.MappingBuilder<AsyncMockHttpServer> preFilter(Matcher1<HttpRequest> matcher) {
        return new AsyncHttpService.MappingBuilder(this::addPreFilter).when(Objects.requireNonNull(matcher));
    }

    public AsyncMockHttpServer preFilter(PreFilter filter) {
        return this.preFilter(arg_0 -> ((Function1)filter.andThen(Future::success)).apply(arg_0));
    }

    public AsyncMockHttpServer preFilter(AsyncPreFilter filter) {
        this.serverK.preFilter((PreFilterK<Future_>)filter);
        return this;
    }

    public AsyncMockHttpServer postFilter(PostFilter filter) {
        return this.postFilter(arg_0 -> ((Function1)filter.andThen(Future::success)).apply(arg_0));
    }

    public AsyncMockHttpServer postFilter(AsyncPostFilter filter) {
        this.serverK.postFilter((PostFilterK<Future_>)filter);
        return this;
    }

    public AsyncMockHttpServer addMapping(Matcher1<HttpRequest> matcher, AsyncRequestHandler handler) {
        this.serverK.addMapping(matcher, (RequestHandlerK<Future_>)handler);
        return this;
    }

    public AsyncMockHttpServer addPreFilter(Matcher1<HttpRequest> matcher, AsyncRequestHandler handler) {
        this.serverK.preFilter((PreFilterK<Future_>)PreFilterK.filter((Monad)FutureInstances.monad(), matcher, (RequestHandlerK)handler));
        return this;
    }

    public AsyncHttpService.MappingBuilder<AsyncMockHttpServer> when(Matcher1<HttpRequest> matcher) {
        return new AsyncHttpService.MappingBuilder(this::addMapping).when(matcher);
    }

    @Override
    public AsyncMockHttpServer start() {
        this.serverK.start();
        return this;
    }

    @Override
    public void stop() {
        this.serverK.stop();
    }

    @Override
    public AsyncMockHttpServer verify(Matcher1<HttpRequest> matcher) {
        this.serverK.verify((Matcher1)matcher);
        return this;
    }

    @Override
    public AsyncMockHttpServer verifyNot(Matcher1<HttpRequest> matcher) {
        this.serverK.verifyNot((Matcher1)matcher);
        return this;
    }

    @Override
    public List<HttpRequest> getUnmatched() {
        return this.serverK.getUnmatched();
    }

    @Override
    public void reset() {
        this.serverK.reset();
    }
}

