/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.zeromock.server;

import com.github.tonivade.purefun.Function1;
import com.github.tonivade.purefun.Matcher1;
import com.github.tonivade.purefun.concurrent.Future;
import com.github.tonivade.purefun.instances.IOInstances;
import com.github.tonivade.purefun.monad.IO;
import com.github.tonivade.purefun.monad.IO_;
import com.github.tonivade.purefun.typeclasses.Monad;
import com.github.tonivade.zeromock.api.HttpIOService;
import com.github.tonivade.zeromock.api.HttpRequest;
import com.github.tonivade.zeromock.api.HttpServiceK;
import com.github.tonivade.zeromock.api.IOPostFilter;
import com.github.tonivade.zeromock.api.IOPreFilter;
import com.github.tonivade.zeromock.api.IORequestHandler;
import com.github.tonivade.zeromock.api.PostFilter;
import com.github.tonivade.zeromock.api.PostFilterK;
import com.github.tonivade.zeromock.api.PreFilter;
import com.github.tonivade.zeromock.api.PreFilterK;
import com.github.tonivade.zeromock.api.RequestHandlerK;
import com.github.tonivade.zeromock.server.HttpServer;
import com.github.tonivade.zeromock.server.MockHttpServerK;
import com.github.tonivade.zeromock.server.ResponseInterpreterK;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;

public final class IOMockHttpServer
implements HttpServer {
    private final MockHttpServerK<IO_> serverK;

    public IOMockHttpServer(com.sun.net.httpserver.HttpServer server) {
        this(new MockHttpServerK<IO_>(server, IOInstances.monad(), ResponseInterpreterK.ioSync()));
    }

    private IOMockHttpServer(MockHttpServerK<IO_> serverK) {
        this.serverK = Objects.requireNonNull(serverK);
    }

    @Override
    public int getPort() {
        return this.serverK.getPort();
    }

    @Override
    public String getPath() {
        return this.serverK.getPath();
    }

    public static MockHttpServerK.BuilderK<IO_> sync() {
        return new MockHttpServerK.BuilderK<IO_>(IOInstances.monad(), ResponseInterpreterK.ioSync());
    }

    public static MockHttpServerK.BuilderK<IO_> async() {
        return IOMockHttpServer.async(Future.DEFAULT_EXECUTOR);
    }

    public static MockHttpServerK.BuilderK<IO_> async(Executor executor) {
        return new MockHttpServerK.BuilderK<IO_>(IOInstances.monad(), ResponseInterpreterK.ioAsync(executor));
    }

    public static IOMockHttpServer listenAt(int port) {
        return new IOMockHttpServer(IOMockHttpServer.sync().port(port).build());
    }

    public IOMockHttpServer mount(String path, HttpIOService other) {
        this.serverK.mount(path, (HttpServiceK<IO_>)other.build());
        return this;
    }

    public IOMockHttpServer exec(IORequestHandler handler) {
        this.serverK.exec((RequestHandlerK<IO_>)handler);
        return this;
    }

    public HttpIOService.MappingBuilder<IOMockHttpServer> preFilter(Matcher1<HttpRequest> matcher) {
        return new HttpIOService.MappingBuilder(this::addMapping).when(matcher);
    }

    public IOMockHttpServer preFilter(PreFilter filter) {
        return this.preFilter(arg_0 -> ((Function1)filter.andThen(IO::pure)).apply(arg_0));
    }

    public IOMockHttpServer preFilter(IOPreFilter filter) {
        this.serverK.preFilter((PreFilterK<IO_>)filter);
        return this;
    }

    public IOMockHttpServer postFilter(PostFilter filter) {
        return this.postFilter(arg_0 -> ((Function1)filter.andThen(IO::pure)).apply(arg_0));
    }

    public IOMockHttpServer postFilter(IOPostFilter filter) {
        this.serverK.postFilter((PostFilterK<IO_>)filter);
        return this;
    }

    public IOMockHttpServer addMapping(Matcher1<HttpRequest> matcher, IORequestHandler handler) {
        this.serverK.addMapping(matcher, (RequestHandlerK<IO_>)handler);
        return this;
    }

    public IOMockHttpServer addPreFilter(Matcher1<HttpRequest> matcher, IORequestHandler handler) {
        this.serverK.preFilter((PreFilterK<IO_>)PreFilterK.filter((Monad)IOInstances.monad(), matcher, (RequestHandlerK)handler));
        return this;
    }

    public HttpIOService.MappingBuilder<IOMockHttpServer> when(Matcher1<HttpRequest> matcher) {
        return new HttpIOService.MappingBuilder(this::addMapping).when(matcher);
    }

    @Override
    public IOMockHttpServer start() {
        this.serverK.start();
        return this;
    }

    @Override
    public void stop() {
        this.serverK.stop();
    }

    @Override
    public IOMockHttpServer verify(Matcher1<HttpRequest> matcher) {
        this.serverK.verify((Matcher1)matcher);
        return this;
    }

    @Override
    public IOMockHttpServer verifyNot(Matcher1<HttpRequest> matcher) {
        this.serverK.verifyNot((Matcher1)matcher);
        return this;
    }

    @Override
    public List<HttpRequest> getUnmatched() {
        return this.serverK.getUnmatched();
    }

    @Override
    public void reset() {
        this.serverK.reset();
    }
}

