/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.zeromock.server;

import com.github.tonivade.purefun.Function1;
import com.github.tonivade.purefun.Matcher1;
import com.github.tonivade.purefun.instances.IdInstances;
import com.github.tonivade.purefun.type.Id_;
import com.github.tonivade.purefun.typeclasses.Monad;
import com.github.tonivade.zeromock.api.HttpRequest;
import com.github.tonivade.zeromock.api.HttpService;
import com.github.tonivade.zeromock.api.HttpServiceK;
import com.github.tonivade.zeromock.api.PostFilter;
import com.github.tonivade.zeromock.api.PostFilterK;
import com.github.tonivade.zeromock.api.PreFilter;
import com.github.tonivade.zeromock.api.PreFilterK;
import com.github.tonivade.zeromock.api.RequestHandler;
import com.github.tonivade.zeromock.api.RequestHandlerK;
import com.github.tonivade.zeromock.server.HttpServer;
import com.github.tonivade.zeromock.server.MockHttpServerK;
import com.github.tonivade.zeromock.server.ResponseInterpreterK;
import java.util.List;
import java.util.Objects;

public final class MockHttpServer
implements HttpServer {
    private final MockHttpServerK<Id_> serverK;

    public MockHttpServer(com.sun.net.httpserver.HttpServer server) {
        this(new MockHttpServerK<Id_>(server, IdInstances.monad(), ResponseInterpreterK.sync()));
    }

    private MockHttpServer(MockHttpServerK<Id_> serverK) {
        this.serverK = Objects.requireNonNull(serverK);
    }

    @Override
    public int getPort() {
        return this.serverK.getPort();
    }

    @Override
    public String getPath() {
        return this.serverK.getPath();
    }

    public static MockHttpServerK.BuilderK<Id_> builder() {
        return new MockHttpServerK.BuilderK<Id_>(IdInstances.monad(), ResponseInterpreterK.sync());
    }

    public static MockHttpServer listenAt(int port) {
        return new MockHttpServer(MockHttpServer.builder().port(port).build());
    }

    public MockHttpServer mount(String path, HttpService other) {
        this.serverK.mount(path, (HttpServiceK<Id_>)other.build());
        return this;
    }

    public MockHttpServer exec(RequestHandler handler) {
        this.serverK.exec((RequestHandlerK<Id_>)((RequestHandlerK)arg_0 -> ((Function1)handler.liftId()).apply(arg_0)));
        return this;
    }

    public HttpService.MappingBuilder<MockHttpServer> preFilter(Matcher1<HttpRequest> matcher) {
        return new HttpService.MappingBuilder(this::addPreFilter).when(matcher);
    }

    public MockHttpServer preFilter(PreFilter filter) {
        this.serverK.preFilter((PreFilterK<Id_>)((PreFilterK)arg_0 -> ((Function1)filter.liftId()).apply(arg_0)));
        return this;
    }

    public MockHttpServer postFilter(PostFilter filter) {
        this.serverK.postFilter((PostFilterK<Id_>)((PostFilterK)arg_0 -> ((Function1)filter.liftId()).apply(arg_0)));
        return this;
    }

    protected MockHttpServer addMapping(Matcher1<HttpRequest> matcher, RequestHandler handler) {
        this.serverK.addMapping(matcher, (RequestHandlerK<Id_>)((RequestHandlerK)arg_0 -> ((Function1)handler.liftId()).apply(arg_0)));
        return this;
    }

    protected MockHttpServer addPreFilter(Matcher1<HttpRequest> matcher, RequestHandler handler) {
        this.serverK.preFilter((PreFilterK<Id_>)((PreFilterK)arg_0 -> ((PreFilterK)PreFilterK.filter((Monad)IdInstances.monad(), matcher, arg_0 -> ((Function1)handler.liftId()).apply(arg_0))).apply(arg_0)));
        return this;
    }

    public HttpService.MappingBuilder<MockHttpServer> when(Matcher1<HttpRequest> matcher) {
        return new HttpService.MappingBuilder(this::addMapping).when(matcher);
    }

    @Override
    public MockHttpServer start() {
        this.serverK.start();
        return this;
    }

    @Override
    public void stop() {
        this.serverK.stop();
    }

    @Override
    public MockHttpServer verify(Matcher1<HttpRequest> matcher) {
        this.serverK.verify((Matcher1)matcher);
        return this;
    }

    @Override
    public MockHttpServer verifyNot(Matcher1<HttpRequest> matcher) {
        this.serverK.verifyNot((Matcher1)matcher);
        return this;
    }

    @Override
    public List<HttpRequest> getUnmatched() {
        return this.serverK.getUnmatched();
    }

    @Override
    public void reset() {
        this.serverK.reset();
    }
}

