/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.zeromock.server;

import com.github.tonivade.purefun.Kind;
import com.github.tonivade.purefun.Matcher1;
import com.github.tonivade.purefun.Witness;
import com.github.tonivade.purefun.type.Option;
import com.github.tonivade.purefun.typeclasses.Monad;
import com.github.tonivade.zeromock.api.Bytes;
import com.github.tonivade.zeromock.api.HttpHeaders;
import com.github.tonivade.zeromock.api.HttpMethod;
import com.github.tonivade.zeromock.api.HttpParams;
import com.github.tonivade.zeromock.api.HttpPath;
import com.github.tonivade.zeromock.api.HttpRequest;
import com.github.tonivade.zeromock.api.HttpResponse;
import com.github.tonivade.zeromock.api.HttpServiceK;
import com.github.tonivade.zeromock.api.PostFilterK;
import com.github.tonivade.zeromock.api.PreFilterK;
import com.github.tonivade.zeromock.api.RequestHandlerK;
import com.github.tonivade.zeromock.api.Responses;
import com.github.tonivade.zeromock.server.HttpServer;
import com.github.tonivade.zeromock.server.ResponseInterpreterK;
import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.InetSocketAddress;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.logging.Logger;

public class MockHttpServerK<F extends Witness>
implements HttpServer {
    private static final Logger LOG = Logger.getLogger(MockHttpServerK.class.getName());
    private static final String ROOT = "/";
    private final com.sun.net.httpserver.HttpServer server;
    private final HttpContext context;
    private final Monad<F> monad;
    private final ResponseInterpreterK<F> interpreter;
    private final Map<Instant, HttpRequest> matched = new LimitedSizeMap<Instant, HttpRequest>(100);
    private final Map<Instant, HttpRequest> unmatched = new LimitedSizeMap<Instant, HttpRequest>(100);
    private HttpServiceK<F> service;

    protected MockHttpServerK(com.sun.net.httpserver.HttpServer server, Monad<F> monad, ResponseInterpreterK<F> interpreter) {
        this.server = Objects.requireNonNull(server);
        this.monad = Objects.requireNonNull(monad);
        this.interpreter = Objects.requireNonNull(interpreter);
        this.service = new HttpServiceK("root", monad);
        this.context = server.createContext(ROOT, this::handle);
    }

    @Override
    public int getPort() {
        return this.server.getAddress().getPort();
    }

    @Override
    public String getPath() {
        return this.context.getPath();
    }

    public MockHttpServerK<F> mount(String path, HttpServiceK<F> other) {
        this.service = this.service.mount(path, other);
        return this;
    }

    public MockHttpServerK<F> exec(RequestHandlerK<F> handler) {
        this.service = this.service.exec(handler);
        return this;
    }

    public HttpServiceK.MappingBuilderK<F, MockHttpServerK<F>> when(Matcher1<HttpRequest> matcher) {
        return new HttpServiceK.MappingBuilderK(this::addMapping).when(Objects.requireNonNull(matcher));
    }

    public HttpServiceK.MappingBuilderK<F, MockHttpServerK<F>> preFilter(Matcher1<HttpRequest> matcher) {
        return new HttpServiceK.MappingBuilderK(this::addPreFilter).when(Objects.requireNonNull(matcher));
    }

    public MockHttpServerK<F> preFilter(PreFilterK<F> filter) {
        this.service = this.service.preFilter(filter);
        return this;
    }

    public MockHttpServerK<F> postFilter(PostFilterK<F> filter) {
        this.service = this.service.postFilter(filter);
        return this;
    }

    @Override
    public MockHttpServerK<F> start() {
        this.server.start();
        LOG.info(() -> "server listening at " + this.server.getAddress());
        return this;
    }

    @Override
    public void stop() {
        this.server.stop(0);
        LOG.info(() -> "server stopped");
    }

    @Override
    public MockHttpServerK<F> verify(Matcher1<HttpRequest> matcher) {
        if (!this.matches(matcher)) {
            throw new AssertionError((Object)"request not found");
        }
        return this;
    }

    @Override
    public MockHttpServerK<F> verifyNot(Matcher1<HttpRequest> matcher) {
        if (this.matches(matcher)) {
            throw new AssertionError((Object)"request not found");
        }
        return this;
    }

    @Override
    public List<HttpRequest> getUnmatched() {
        return Collections.unmodifiableList(new ArrayList<HttpRequest>(this.unmatched.values()));
    }

    @Override
    public void reset() {
        this.service = new HttpServiceK("root", this.monad);
        this.matched.clear();
        this.unmatched.clear();
    }

    protected MockHttpServerK<F> addMapping(Matcher1<HttpRequest> matcher, RequestHandlerK<F> handler) {
        this.service = this.service.addMapping(matcher, handler);
        return this;
    }

    protected MockHttpServerK<F> addPreFilter(Matcher1<HttpRequest> matcher, RequestHandlerK<F> handler) {
        this.service = this.service.addPreFilter(matcher, handler);
        return this;
    }

    private void handle(HttpExchange exchange) throws IOException {
        HttpRequest request = this.createRequest(exchange);
        this.interpreter.run(this.monad.map(this.execute(request), option -> this.fold(request, (Option<HttpResponse>)option))).onSuccess(response -> this.processResponse(exchange, (HttpResponse)response)).onFailure(error -> this.processResponse(exchange, Responses.error((Throwable)error)));
    }

    private HttpResponse fold(HttpRequest request, Option<HttpResponse> option) {
        return (HttpResponse)option.ifPresent(response -> this.matched(request)).ifEmpty(() -> this.unmatched(request)).getOrElse(Responses::notFound);
    }

    private void unmatched(HttpRequest request) {
        LOG.fine(() -> "unmatched request " + request);
        this.unmatched.put(Instant.now(), request);
    }

    private void matched(HttpRequest request) {
        this.matched.put(Instant.now(), request);
    }

    private boolean matches(Matcher1<HttpRequest> matcher) {
        return this.matched.values().stream().anyMatch(arg_0 -> matcher.match(arg_0));
    }

    private Kind<F, Option<HttpResponse>> execute(HttpRequest request) {
        return this.service.execute(request);
    }

    private HttpRequest createRequest(HttpExchange exchange) throws IOException {
        HttpMethod method = HttpMethod.valueOf((String)exchange.getRequestMethod());
        HttpHeaders headers = HttpHeaders.from((Map)exchange.getRequestHeaders());
        HttpParams params = new HttpParams(exchange.getRequestURI().getQuery());
        HttpPath path = HttpPath.from((String)exchange.getRequestURI().getPath());
        Bytes body = Bytes.asBytes((InputStream)exchange.getRequestBody());
        return new HttpRequest(method, path, body, headers, params);
    }

    private void processResponse(HttpExchange exchange, HttpResponse response) {
        try {
            Bytes bytes = response.body();
            response.headers().forEach((key, value) -> exchange.getResponseHeaders().add((String)key, (String)value));
            exchange.sendResponseHeaders(response.status().code(), bytes.size());
            try (OutputStream output = exchange.getResponseBody();){
                output.write(bytes.toArray());
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            exchange.close();
        }
    }

    private static final class LimitedSizeMap<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = 1L;
        private final int maxSize;

        private LimitedSizeMap(int maxSize) {
            super(maxSize);
            this.maxSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.maxSize;
        }
    }

    public static final class Builder {
        private String host = "localhost";
        private int port = 8080;
        private int threads = Runtime.getRuntime().availableProcessors();
        private int backlog = 0;

        public Builder host(String host) {
            this.host = Objects.requireNonNull(host);
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder threads(int threads) {
            this.threads = threads;
            return this;
        }

        public Builder backlog(int backlog) {
            this.backlog = backlog;
            return this;
        }

        public com.sun.net.httpserver.HttpServer build() {
            try {
                com.sun.net.httpserver.HttpServer server = com.sun.net.httpserver.HttpServer.create(new InetSocketAddress(this.host, this.port), this.backlog);
                server.setExecutor(Executors.newFixedThreadPool(this.threads));
                return server;
            }
            catch (IOException e) {
                throw new UncheckedIOException("unable to create server at " + this.host + ":" + this.port, e);
            }
        }
    }

    public static final class BuilderK<F extends Witness> {
        private final Monad<F> monad;
        private final ResponseInterpreterK<F> interpreter;
        private final Builder builder = new Builder();

        public BuilderK(Monad<F> monad, ResponseInterpreterK<F> interpreter) {
            this.monad = Objects.requireNonNull(monad);
            this.interpreter = Objects.requireNonNull(interpreter);
        }

        public BuilderK<F> host(String host) {
            this.builder.host(host);
            return this;
        }

        public BuilderK<F> port(int port) {
            this.builder.port(port);
            return this;
        }

        public BuilderK<F> threads(int threads) {
            this.builder.threads(threads);
            return this;
        }

        public BuilderK<F> backlog(int backlog) {
            this.builder.backlog(backlog);
            return this;
        }

        public MockHttpServerK<F> build() {
            return new MockHttpServerK<F>(this.builder.build(), this.monad, this.interpreter);
        }
    }
}

