/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.zeromock.server;

import com.github.tonivade.purefun.Kind;
import com.github.tonivade.purefun.Nothing;
import com.github.tonivade.purefun.Producer;
import com.github.tonivade.purefun.Witness;
import com.github.tonivade.purefun.concurrent.Future;
import com.github.tonivade.purefun.concurrent.FutureOf;
import com.github.tonivade.purefun.concurrent.Future_;
import com.github.tonivade.purefun.concurrent.Promise;
import com.github.tonivade.purefun.effect.UIO;
import com.github.tonivade.purefun.effect.UIOOf;
import com.github.tonivade.purefun.effect.UIO_;
import com.github.tonivade.purefun.effect.ZIO;
import com.github.tonivade.purefun.effect.ZIOOf;
import com.github.tonivade.purefun.effect.ZIO_;
import com.github.tonivade.purefun.instances.FutureInstances;
import com.github.tonivade.purefun.monad.IO;
import com.github.tonivade.purefun.monad.IOOf;
import com.github.tonivade.purefun.monad.IO_;
import com.github.tonivade.purefun.type.Either;
import com.github.tonivade.purefun.type.Id;
import com.github.tonivade.purefun.type.IdOf;
import com.github.tonivade.purefun.type.Id_;
import com.github.tonivade.zeromock.api.HttpResponse;
import java.util.concurrent.Executor;

@FunctionalInterface
public interface ResponseInterpreterK<F extends Witness> {
    public Promise<HttpResponse> run(Kind<F, HttpResponse> var1);

    public static ResponseInterpreterK<Future_> async() {
        return response -> {
            Future future = (Future)response.fix(FutureOf::narrowK);
            return future.toPromise();
        };
    }

    public static ResponseInterpreterK<Id_> sync() {
        return response -> {
            Id value = (Id)response.fix(IdOf::narrowK);
            return Promise.make().succeeded(value.get());
        };
    }

    public static ResponseInterpreterK<IO_> ioSync() {
        return response -> {
            IO value = (IO)response.fix(IOOf::narrowK);
            return Promise.make().succeeded(value.unsafeRunSync());
        };
    }

    public static ResponseInterpreterK<IO_> ioAsync(Executor executor) {
        return response -> {
            IO value = (IO)response.fix(IOOf::narrowK);
            Kind future = value.foldMap(FutureInstances.monadDefer((Executor)executor));
            return ((Future)future.fix(FutureOf::narrowK)).toPromise();
        };
    }

    public static ResponseInterpreterK<UIO_> uioSync() {
        return response -> {
            UIO value = (UIO)response.fix(UIOOf::narrowK);
            return Promise.make().succeeded(value.unsafeRunSync());
        };
    }

    public static ResponseInterpreterK<UIO_> uioAsync(Executor executor) {
        return response -> {
            UIO value = (UIO)response.fix(UIOOf::narrowK);
            Kind future = value.foldMap(FutureInstances.monadDefer((Executor)executor));
            return ((Future)future.fix(FutureOf::narrowK)).toPromise();
        };
    }

    public static <R> ResponseInterpreterK<Kind<Kind<ZIO_, R>, Nothing>> zioSync(Producer<R> factory) {
        return response -> {
            ZIO future = (ZIO)response.fix(ZIOOf::narrowK);
            return Promise.make().succeeded(future.provide(factory.get()).get());
        };
    }

    public static <R> ResponseInterpreterK<Kind<Kind<ZIO_, R>, Nothing>> zioAsync(Producer<R> factory, Executor executor) {
        return response -> {
            ZIO effect = (ZIO)response.fix(ZIOOf::narrowK);
            Kind future = effect.foldMap(factory.get(), FutureInstances.monadDefer((Executor)executor));
            return ((Future)future.fix(FutureOf::narrowK)).map(Either::get).toPromise();
        };
    }
}

