/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.zeromock.server;

import com.github.tonivade.purefun.Function1;
import com.github.tonivade.purefun.Matcher1;
import com.github.tonivade.purefun.concurrent.Future;
import com.github.tonivade.purefun.effect.UIO;
import com.github.tonivade.purefun.effect.UIO_;
import com.github.tonivade.purefun.instances.UIOInstances;
import com.github.tonivade.purefun.typeclasses.Monad;
import com.github.tonivade.zeromock.api.HttpRequest;
import com.github.tonivade.zeromock.api.HttpServiceK;
import com.github.tonivade.zeromock.api.HttpUIOService;
import com.github.tonivade.zeromock.api.PostFilter;
import com.github.tonivade.zeromock.api.PostFilterK;
import com.github.tonivade.zeromock.api.PreFilter;
import com.github.tonivade.zeromock.api.PreFilterK;
import com.github.tonivade.zeromock.api.RequestHandlerK;
import com.github.tonivade.zeromock.api.UIOPostFilter;
import com.github.tonivade.zeromock.api.UIOPreFilter;
import com.github.tonivade.zeromock.api.UIORequestHandler;
import com.github.tonivade.zeromock.server.HttpServer;
import com.github.tonivade.zeromock.server.MockHttpServerK;
import com.github.tonivade.zeromock.server.ResponseInterpreterK;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;

public final class UIOMockHttpServer
implements HttpServer {
    private final MockHttpServerK<UIO_> serverK;

    public UIOMockHttpServer(com.sun.net.httpserver.HttpServer server) {
        this(new MockHttpServerK<UIO_>(server, UIOInstances.monad(), ResponseInterpreterK.uioSync()));
    }

    private UIOMockHttpServer(MockHttpServerK<UIO_> serverK) {
        this.serverK = Objects.requireNonNull(serverK);
    }

    @Override
    public int getPort() {
        return this.serverK.getPort();
    }

    @Override
    public String getPath() {
        return this.serverK.getPath();
    }

    public static MockHttpServerK.BuilderK<UIO_> sync() {
        return new MockHttpServerK.BuilderK<UIO_>(UIOInstances.monad(), ResponseInterpreterK.uioSync());
    }

    public static MockHttpServerK.BuilderK<UIO_> async() {
        return UIOMockHttpServer.async(Future.DEFAULT_EXECUTOR);
    }

    public static MockHttpServerK.BuilderK<UIO_> async(Executor executor) {
        return new MockHttpServerK.BuilderK<UIO_>(UIOInstances.monad(), ResponseInterpreterK.uioAsync(executor));
    }

    public static UIOMockHttpServer listenAt(int port) {
        return new UIOMockHttpServer(UIOMockHttpServer.sync().port(port).build());
    }

    public UIOMockHttpServer mount(String path, HttpUIOService other) {
        this.serverK.mount(path, (HttpServiceK<UIO_>)other.build());
        return this;
    }

    public UIOMockHttpServer exec(UIORequestHandler handler) {
        this.serverK.exec((RequestHandlerK<UIO_>)handler);
        return this;
    }

    public HttpUIOService.MappingBuilder<UIOMockHttpServer> preFilter(Matcher1<HttpRequest> matcher) {
        return new HttpUIOService.MappingBuilder(this::addPreFilter).when(matcher);
    }

    public UIOMockHttpServer preFilter(PreFilter filter) {
        return this.preFilter(arg_0 -> ((Function1)filter.andThen(UIO::pure)).apply(arg_0));
    }

    public UIOMockHttpServer preFilter(UIOPreFilter filter) {
        this.serverK.preFilter((PreFilterK<UIO_>)filter);
        return this;
    }

    public UIOMockHttpServer postFilter(PostFilter filter) {
        return this.postFilter(arg_0 -> ((Function1)filter.andThen(UIO::pure)).apply(arg_0));
    }

    public UIOMockHttpServer postFilter(UIOPostFilter filter) {
        this.serverK.postFilter((PostFilterK<UIO_>)filter);
        return this;
    }

    public UIOMockHttpServer addMapping(Matcher1<HttpRequest> matcher, UIORequestHandler handler) {
        this.serverK.addMapping(matcher, (RequestHandlerK<UIO_>)handler);
        return this;
    }

    public UIOMockHttpServer addPreFilter(Matcher1<HttpRequest> matcher, UIORequestHandler handler) {
        this.serverK.preFilter((PreFilterK<UIO_>)PreFilterK.filter((Monad)UIOInstances.monad(), matcher, (RequestHandlerK)handler));
        return this;
    }

    public HttpUIOService.MappingBuilder<UIOMockHttpServer> when(Matcher1<HttpRequest> matcher) {
        return new HttpUIOService.MappingBuilder(this::addMapping).when(matcher);
    }

    @Override
    public UIOMockHttpServer start() {
        this.serverK.start();
        return this;
    }

    @Override
    public void stop() {
        this.serverK.stop();
    }

    @Override
    public UIOMockHttpServer verify(Matcher1<HttpRequest> matcher) {
        this.serverK.verify((Matcher1)matcher);
        return this;
    }

    @Override
    public UIOMockHttpServer verifyNot(Matcher1<HttpRequest> matcher) {
        this.serverK.verifyNot((Matcher1)matcher);
        return this;
    }

    @Override
    public List<HttpRequest> getUnmatched() {
        return this.serverK.getUnmatched();
    }

    @Override
    public void reset() {
        this.serverK.reset();
    }
}

