/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.zeromock.server;

import com.github.tonivade.purefun.Function1;
import com.github.tonivade.purefun.Kind;
import com.github.tonivade.purefun.Matcher1;
import com.github.tonivade.purefun.Nothing;
import com.github.tonivade.purefun.Producer;
import com.github.tonivade.purefun.concurrent.Future;
import com.github.tonivade.purefun.effect.ZIO;
import com.github.tonivade.purefun.effect.ZIO_;
import com.github.tonivade.purefun.instances.ZIOInstances;
import com.github.tonivade.purefun.typeclasses.Monad;
import com.github.tonivade.zeromock.api.HttpRequest;
import com.github.tonivade.zeromock.api.HttpZIOService;
import com.github.tonivade.zeromock.api.PostFilter;
import com.github.tonivade.zeromock.api.PostFilterK;
import com.github.tonivade.zeromock.api.PreFilter;
import com.github.tonivade.zeromock.api.PreFilterK;
import com.github.tonivade.zeromock.api.RequestHandlerK;
import com.github.tonivade.zeromock.api.ZIOPostFilter;
import com.github.tonivade.zeromock.api.ZIOPreFilter;
import com.github.tonivade.zeromock.api.ZIORequestHandler;
import com.github.tonivade.zeromock.server.HttpServer;
import com.github.tonivade.zeromock.server.MockHttpServerK;
import com.github.tonivade.zeromock.server.ResponseInterpreterK;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;

public final class ZIOMockHttpServer<R>
implements HttpServer {
    private final MockHttpServerK<Kind<Kind<ZIO_, R>, Nothing>> serverK;

    private ZIOMockHttpServer(MockHttpServerK<Kind<Kind<ZIO_, R>, Nothing>> serverK) {
        this.serverK = Objects.requireNonNull(serverK);
    }

    @Override
    public int getPort() {
        return this.serverK.getPort();
    }

    @Override
    public String getPath() {
        return this.serverK.getPath();
    }

    public static <R> MockHttpServerK.BuilderK<Kind<Kind<ZIO_, R>, Nothing>> builder(Producer<R> factory) {
        return new MockHttpServerK.BuilderK<Kind<Kind<ZIO_, R>, Nothing>>(ZIOInstances.monad(), ResponseInterpreterK.zioSync(factory));
    }

    public static <R> MockHttpServerK.BuilderK<Kind<Kind<ZIO_, R>, Nothing>> async(Producer<R> factory) {
        return ZIOMockHttpServer.async(Future.DEFAULT_EXECUTOR, factory);
    }

    public static <R> MockHttpServerK.BuilderK<Kind<Kind<ZIO_, R>, Nothing>> async(Executor executor, Producer<R> factory) {
        return new MockHttpServerK.BuilderK<Kind<Kind<ZIO_, R>, Nothing>>(ZIOInstances.monad(), ResponseInterpreterK.zioAsync(factory, executor));
    }

    public static <R> ZIOMockHttpServer<R> listenAt(R env, int port) {
        return new ZIOMockHttpServer<R>(ZIOMockHttpServer.builder(Producer.cons(env)).port(port).build());
    }

    public ZIOMockHttpServer<R> mount(String path, HttpZIOService<R> other) {
        this.serverK.mount(path, other.build());
        return this;
    }

    public ZIOMockHttpServer<R> exec(ZIORequestHandler<R> handler) {
        this.serverK.exec((RequestHandlerK<Kind<Kind<ZIO_, R>, Nothing>>)handler);
        return this;
    }

    public HttpZIOService.MappingBuilder<R, ZIOMockHttpServer<R>> preFilter(Matcher1<HttpRequest> matcher) {
        return new HttpZIOService.MappingBuilder(this::addMapping).when(matcher);
    }

    public ZIOMockHttpServer<R> preFilter(PreFilter filter) {
        return this.preFilter(arg_0 -> ((Function1)filter.andThen(ZIO::pure)).apply(arg_0));
    }

    public ZIOMockHttpServer<R> preFilter(ZIOPreFilter<R> filter) {
        this.serverK.preFilter((PreFilterK<Kind<Kind<ZIO_, R>, Nothing>>)filter);
        return this;
    }

    public ZIOMockHttpServer<R> postFilter(PostFilter filter) {
        return this.postFilter(arg_0 -> ((Function1)filter.andThen(ZIO::pure)).apply(arg_0));
    }

    public ZIOMockHttpServer<R> postFilter(ZIOPostFilter<R> filter) {
        this.serverK.postFilter((PostFilterK<Kind<Kind<ZIO_, R>, Nothing>>)filter);
        return this;
    }

    public ZIOMockHttpServer<R> addMapping(Matcher1<HttpRequest> matcher, ZIORequestHandler<R> handler) {
        this.serverK.addMapping(matcher, (RequestHandlerK<Kind<Kind<ZIO_, R>, Nothing>>)handler);
        return this;
    }

    public ZIOMockHttpServer<R> addPreFilter(Matcher1<HttpRequest> matcher, ZIORequestHandler<R> handler) {
        this.serverK.preFilter(PreFilterK.filter((Monad)ZIOInstances.monad(), matcher, handler));
        return this;
    }

    public HttpZIOService.MappingBuilder<R, ZIOMockHttpServer<R>> when(Matcher1<HttpRequest> matcher) {
        return new HttpZIOService.MappingBuilder(this::addMapping).when(matcher);
    }

    @Override
    public ZIOMockHttpServer<R> start() {
        this.serverK.start();
        return this;
    }

    @Override
    public void stop() {
        this.serverK.stop();
    }

    @Override
    public ZIOMockHttpServer<R> verify(Matcher1<HttpRequest> matcher) {
        this.serverK.verify((Matcher1)matcher);
        return this;
    }

    @Override
    public ZIOMockHttpServer<R> verifyNot(Matcher1<HttpRequest> matcher) {
        this.serverK.verifyNot((Matcher1)matcher);
        return this;
    }

    @Override
    public List<HttpRequest> getUnmatched() {
        return this.serverK.getUnmatched();
    }

    @Override
    public void reset() {
        this.serverK.reset();
    }
}

