/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.zeromock.server;

import com.github.tonivade.purefun.Kind;
import com.github.tonivade.purefun.concurrent.Future;
import com.github.tonivade.purefun.core.Matcher1;
import com.github.tonivade.purefun.data.Sequence;
import com.github.tonivade.purefun.typeclasses.Instances;
import com.github.tonivade.zeromock.api.AsyncHttpService;
import com.github.tonivade.zeromock.api.HttpRequest;
import com.github.tonivade.zeromock.api.HttpRouteBuilderK;
import com.github.tonivade.zeromock.api.PostFilter;
import com.github.tonivade.zeromock.api.PostFilterK;
import com.github.tonivade.zeromock.api.PreFilter;
import com.github.tonivade.zeromock.api.PreFilterK;
import com.github.tonivade.zeromock.api.RequestHandlerK;
import com.github.tonivade.zeromock.server.HttpServer;
import com.github.tonivade.zeromock.server.MockHttpServerK;
import com.github.tonivade.zeromock.server.ResponseInterpreterK;
import java.util.Objects;

public final class AsyncMockHttpServer
implements HttpServer,
HttpRouteBuilderK<Future<?>, AsyncMockHttpServer> {
    private final MockHttpServerK<Future<?>> serverK;

    public AsyncMockHttpServer(com.sun.net.httpserver.HttpServer server) {
        this(new MockHttpServerK(server, Instances.monad((Kind[])new Future[0]), ResponseInterpreterK.async()));
    }

    private AsyncMockHttpServer(MockHttpServerK<Future<?>> serverK) {
        this.serverK = Objects.requireNonNull(serverK);
    }

    @Override
    public int getPort() {
        return this.serverK.getPort();
    }

    @Override
    public String getPath() {
        return this.serverK.getPath();
    }

    public static MockHttpServerK.BuilderK<Future<?>, AsyncMockHttpServer> builder() {
        return new MockHttpServerK.BuilderK<Future<?>, AsyncMockHttpServer>(Instances.monad((Kind[])new Future[0]), (ResponseInterpreterK)ResponseInterpreterK.async()){

            @Override
            public AsyncMockHttpServer build() {
                return new AsyncMockHttpServer(this.buildK());
            }
        };
    }

    public static AsyncMockHttpServer listenAtRandomPort() {
        return AsyncMockHttpServer.listenAt(0);
    }

    public static AsyncMockHttpServer listenAt(int port) {
        return AsyncMockHttpServer.builder().port(port).build();
    }

    public static AsyncMockHttpServer listenAt(String host, int port) {
        return AsyncMockHttpServer.builder().host(host).port(port).build();
    }

    public AsyncMockHttpServer mount(String path, AsyncHttpService other) {
        this.serverK.mount(path, other.build());
        return this;
    }

    public AsyncMockHttpServer exec(RequestHandlerK<Future<?>> handler) {
        this.serverK.exec(handler);
        return this;
    }

    public HttpRouteBuilderK.ThenStepK<Future<?>, AsyncMockHttpServer> preFilter(Matcher1<HttpRequest> matcher) {
        return new HttpRouteBuilderK.ThenStepK(this.serverK.monad(), handler -> this.addPreFilter(matcher, (RequestHandlerK<Future<?>>)handler));
    }

    public AsyncMockHttpServer preFilter(PreFilter filter) {
        return this.preFilter(filter.lift(this.serverK.monad()));
    }

    public AsyncMockHttpServer preFilter(PreFilterK<Future<?>> filter) {
        this.serverK.preFilter(filter);
        return this;
    }

    public AsyncMockHttpServer postFilter(PostFilter filter) {
        return this.postFilter(filter.lift(this.serverK.monad()));
    }

    public AsyncMockHttpServer postFilter(PostFilterK<Future<?>> filter) {
        this.serverK.postFilter(filter);
        return this;
    }

    public AsyncMockHttpServer addMapping(Matcher1<HttpRequest> matcher, RequestHandlerK<Future<?>> handler) {
        this.serverK.addMapping(matcher, handler);
        return this;
    }

    public AsyncMockHttpServer addPreFilter(Matcher1<HttpRequest> matcher, RequestHandlerK<Future<?>> handler) {
        this.serverK.preFilter(PreFilterK.filter(this.serverK.monad(), matcher, handler));
        return this;
    }

    public HttpRouteBuilderK.ThenStepK<Future<?>, AsyncMockHttpServer> when(Matcher1<HttpRequest> matcher) {
        return new HttpRouteBuilderK.ThenStepK(this.serverK.monad(), handler -> this.addMapping(matcher, (RequestHandlerK<Future<?>>)handler));
    }

    @Override
    public AsyncMockHttpServer start() {
        this.serverK.start();
        return this;
    }

    @Override
    public void stop() {
        this.serverK.stop();
    }

    @Override
    public AsyncMockHttpServer verify(Matcher1<HttpRequest> matcher) {
        this.serverK.verify((Matcher1)matcher);
        return this;
    }

    @Override
    public AsyncMockHttpServer verify(Matcher1<HttpRequest> matcher, int times) {
        this.serverK.verify((Matcher1)matcher, times);
        return this;
    }

    @Override
    public AsyncMockHttpServer verifyNot(Matcher1<HttpRequest> matcher) {
        this.serverK.verifyNot((Matcher1)matcher);
        return this;
    }

    @Override
    public Sequence<HttpRequest> getUnmatched() {
        return this.serverK.getUnmatched();
    }

    @Override
    public void reset() {
        this.serverK.reset();
    }
}

