/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.zeromock.server;

import com.github.tonivade.purefun.Kind;
import com.github.tonivade.purefun.core.Matcher1;
import com.github.tonivade.purefun.data.Sequence;
import com.github.tonivade.purefun.monad.IO;
import com.github.tonivade.purefun.typeclasses.Instances;
import com.github.tonivade.zeromock.api.HttpIOService;
import com.github.tonivade.zeromock.api.HttpRequest;
import com.github.tonivade.zeromock.api.HttpRouteBuilderK;
import com.github.tonivade.zeromock.api.PostFilter;
import com.github.tonivade.zeromock.api.PostFilterK;
import com.github.tonivade.zeromock.api.PreFilter;
import com.github.tonivade.zeromock.api.PreFilterK;
import com.github.tonivade.zeromock.api.RequestHandlerK;
import com.github.tonivade.zeromock.server.HttpServer;
import com.github.tonivade.zeromock.server.MockHttpServerK;
import com.github.tonivade.zeromock.server.ResponseInterpreterK;
import java.util.Objects;

public final class IOMockHttpServer
implements HttpServer,
HttpRouteBuilderK<IO<?>, IOMockHttpServer> {
    private final MockHttpServerK<IO<?>> serverK;

    public IOMockHttpServer(com.sun.net.httpserver.HttpServer server) {
        this(new MockHttpServerK(server, Instances.monad((Kind[])new IO[0]), ResponseInterpreterK.io()));
    }

    private IOMockHttpServer(MockHttpServerK<IO<?>> serverK) {
        this.serverK = Objects.requireNonNull(serverK);
    }

    @Override
    public int getPort() {
        return this.serverK.getPort();
    }

    @Override
    public String getPath() {
        return this.serverK.getPath();
    }

    public static MockHttpServerK.BuilderK<IO<?>, IOMockHttpServer> builder() {
        return IOMockHttpServer.builder(ResponseInterpreterK.io());
    }

    public static IOMockHttpServer listenAtRandomPort() {
        return IOMockHttpServer.listenAt(0);
    }

    public static IOMockHttpServer listenAt(int port) {
        return IOMockHttpServer.builder().port(port).build();
    }

    public static IOMockHttpServer listenAt(String host, int port) {
        return IOMockHttpServer.builder().host(host).port(port).build();
    }

    public IOMockHttpServer mount(String path, HttpIOService other) {
        this.serverK.mount(path, other.build());
        return this;
    }

    public IOMockHttpServer exec(RequestHandlerK<IO<?>> handler) {
        this.serverK.exec(handler);
        return this;
    }

    public HttpRouteBuilderK.ThenStepK<IO<?>, IOMockHttpServer> preFilter(Matcher1<HttpRequest> matcher) {
        return new HttpRouteBuilderK.ThenStepK(this.serverK.monad(), handler -> this.addPreFilter(matcher, (RequestHandlerK<IO<?>>)handler));
    }

    public IOMockHttpServer preFilter(PreFilter filter) {
        return this.preFilter(filter.lift(this.serverK.monad()));
    }

    public IOMockHttpServer preFilter(PreFilterK<IO<?>> filter) {
        this.serverK.preFilter(filter);
        return this;
    }

    public IOMockHttpServer postFilter(PostFilter filter) {
        return this.postFilter(filter.lift(this.serverK.monad()));
    }

    public IOMockHttpServer postFilter(PostFilterK<IO<?>> filter) {
        this.serverK.postFilter(filter);
        return this;
    }

    public IOMockHttpServer addMapping(Matcher1<HttpRequest> matcher, RequestHandlerK<IO<?>> handler) {
        this.serverK.addMapping(matcher, handler);
        return this;
    }

    public IOMockHttpServer addPreFilter(Matcher1<HttpRequest> matcher, RequestHandlerK<IO<?>> handler) {
        this.serverK.preFilter(PreFilterK.filter(this.serverK.monad(), matcher, handler));
        return this;
    }

    public HttpRouteBuilderK.ThenStepK<IO<?>, IOMockHttpServer> when(Matcher1<HttpRequest> matcher) {
        return new HttpRouteBuilderK.ThenStepK(this.serverK.monad(), handler -> this.addMapping(matcher, (RequestHandlerK<IO<?>>)handler));
    }

    @Override
    public IOMockHttpServer start() {
        this.serverK.start();
        return this;
    }

    @Override
    public void stop() {
        this.serverK.stop();
    }

    @Override
    public IOMockHttpServer verify(Matcher1<HttpRequest> matcher) {
        this.serverK.verify((Matcher1)matcher);
        return this;
    }

    @Override
    public IOMockHttpServer verify(Matcher1<HttpRequest> matcher, int times) {
        this.serverK.verify((Matcher1)matcher, times);
        return this;
    }

    @Override
    public IOMockHttpServer verifyNot(Matcher1<HttpRequest> matcher) {
        this.serverK.verifyNot((Matcher1)matcher);
        return this;
    }

    @Override
    public Sequence<HttpRequest> getUnmatched() {
        return this.serverK.getUnmatched();
    }

    @Override
    public void reset() {
        this.serverK.reset();
    }

    private static MockHttpServerK.BuilderK<IO<?>, IOMockHttpServer> builder(ResponseInterpreterK<IO<?>> interpreter) {
        return new MockHttpServerK.BuilderK<IO<?>, IOMockHttpServer>(Instances.monad((Kind[])new IO[0]), (ResponseInterpreterK)interpreter){

            @Override
            public IOMockHttpServer build() {
                return new IOMockHttpServer(this.buildK());
            }
        };
    }
}

