/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.zeromock.server;

import com.github.tonivade.purefun.Kind;
import com.github.tonivade.purefun.core.Matcher1;
import com.github.tonivade.purefun.data.Sequence;
import com.github.tonivade.purefun.type.Id;
import com.github.tonivade.purefun.typeclasses.Instances;
import com.github.tonivade.zeromock.api.HttpRequest;
import com.github.tonivade.zeromock.api.HttpRouteBuilder;
import com.github.tonivade.zeromock.api.HttpService;
import com.github.tonivade.zeromock.api.PostFilter;
import com.github.tonivade.zeromock.api.PreFilter;
import com.github.tonivade.zeromock.api.PreFilterK;
import com.github.tonivade.zeromock.api.RequestHandler;
import com.github.tonivade.zeromock.api.RequestHandlerK;
import com.github.tonivade.zeromock.server.HttpServer;
import com.github.tonivade.zeromock.server.MockHttpServerK;
import com.github.tonivade.zeromock.server.ResponseInterpreterK;
import java.util.Objects;

public final class MockHttpServer
implements HttpServer,
HttpRouteBuilder<MockHttpServer> {
    private final MockHttpServerK<Id<?>> serverK;

    public MockHttpServer(com.sun.net.httpserver.HttpServer server) {
        this(new MockHttpServerK(server, Instances.monad((Kind[])new Id[0]), ResponseInterpreterK.sync()));
    }

    private MockHttpServer(MockHttpServerK<Id<?>> serverK) {
        this.serverK = Objects.requireNonNull(serverK);
    }

    @Override
    public int getPort() {
        return this.serverK.getPort();
    }

    @Override
    public String getPath() {
        return this.serverK.getPath();
    }

    public static MockHttpServerK.BuilderK<Id<?>, MockHttpServer> builder() {
        return new MockHttpServerK.BuilderK<Id<?>, MockHttpServer>(Instances.monad((Kind[])new Id[0]), (ResponseInterpreterK)ResponseInterpreterK.sync()){

            @Override
            public MockHttpServer build() {
                return new MockHttpServer(this.buildK());
            }
        };
    }

    public static MockHttpServer listenAtRandomPort() {
        return MockHttpServer.listenAt(0);
    }

    public static MockHttpServer listenAt(int port) {
        return MockHttpServer.builder().port(port).build();
    }

    public static MockHttpServer listenAt(String host, int port) {
        return MockHttpServer.builder().host(host).port(port).build();
    }

    public MockHttpServer mount(String path, HttpService other) {
        this.serverK.mount(path, other.build());
        return this;
    }

    public MockHttpServer exec(RequestHandler handler) {
        this.serverK.exec(handler.lift(this.serverK.monad()));
        return this;
    }

    public HttpRouteBuilder.ThenStep<MockHttpServer> preFilter(Matcher1<HttpRequest> matcher) {
        return handler -> this.addPreFilter(matcher, handler);
    }

    public MockHttpServer preFilter(PreFilter filter) {
        this.serverK.preFilter(filter.lift(this.serverK.monad()));
        return this;
    }

    public MockHttpServer postFilter(PostFilter filter) {
        this.serverK.postFilter(filter.lift(this.serverK.monad()));
        return this;
    }

    private MockHttpServer addMapping(Matcher1<HttpRequest> matcher, RequestHandler handler) {
        this.serverK.addMapping(matcher, handler.lift(this.serverK.monad()));
        return this;
    }

    private MockHttpServer addPreFilter(Matcher1<HttpRequest> matcher, RequestHandler handler) {
        this.serverK.preFilter(PreFilterK.filter(this.serverK.monad(), matcher, (RequestHandlerK)handler.lift(this.serverK.monad())));
        return this;
    }

    public HttpRouteBuilder.ThenStep<MockHttpServer> when(Matcher1<HttpRequest> matcher) {
        return handler -> this.addMapping(matcher, handler);
    }

    @Override
    public MockHttpServer start() {
        this.serverK.start();
        return this;
    }

    @Override
    public void stop() {
        this.serverK.stop();
    }

    @Override
    public MockHttpServer verify(Matcher1<HttpRequest> matcher) {
        this.serverK.verify((Matcher1)matcher);
        return this;
    }

    @Override
    public MockHttpServer verify(Matcher1<HttpRequest> matcher, int times) {
        this.serverK.verify((Matcher1)matcher, times);
        return this;
    }

    @Override
    public MockHttpServer verifyNot(Matcher1<HttpRequest> matcher) {
        this.serverK.verifyNot((Matcher1)matcher);
        return this;
    }

    @Override
    public Sequence<HttpRequest> getUnmatched() {
        return this.serverK.getUnmatched();
    }

    @Override
    public void reset() {
        this.serverK.reset();
    }
}

