/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.zeromock.server;

import com.github.tonivade.purefun.Kind;
import com.github.tonivade.purefun.Nullable;
import com.github.tonivade.purefun.core.Matcher1;
import com.github.tonivade.purefun.data.ImmutableList;
import com.github.tonivade.purefun.data.Sequence;
import com.github.tonivade.purefun.type.Option;
import com.github.tonivade.purefun.typeclasses.Monad;
import com.github.tonivade.zeromock.api.Bytes;
import com.github.tonivade.zeromock.api.HttpHeaders;
import com.github.tonivade.zeromock.api.HttpMethod;
import com.github.tonivade.zeromock.api.HttpParams;
import com.github.tonivade.zeromock.api.HttpPath;
import com.github.tonivade.zeromock.api.HttpRequest;
import com.github.tonivade.zeromock.api.HttpResponse;
import com.github.tonivade.zeromock.api.HttpRouteBuilderK;
import com.github.tonivade.zeromock.api.HttpServiceK;
import com.github.tonivade.zeromock.api.PostFilterK;
import com.github.tonivade.zeromock.api.PreFilterK;
import com.github.tonivade.zeromock.api.RequestHandlerK;
import com.github.tonivade.zeromock.api.Responses;
import com.github.tonivade.zeromock.server.HttpServer;
import com.github.tonivade.zeromock.server.ResponseInterpreterK;
import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.InetSocketAddress;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockHttpServerK<F extends Kind<F, ?>>
implements HttpServer,
HttpRouteBuilderK<F, MockHttpServerK<F>> {
    private static final Logger LOG = LoggerFactory.getLogger(MockHttpServerK.class);
    private static final String ROOT = "/";
    private final com.sun.net.httpserver.HttpServer server;
    private final HttpContext context;
    private final Monad<F> monad;
    private final ResponseInterpreterK<F> interpreter;
    private final Map<Instant, HttpRequest> matched = new LimitedSizeMap<Instant, HttpRequest>(100);
    private final Map<Instant, HttpRequest> unmatched = new LimitedSizeMap<Instant, HttpRequest>(100);
    private HttpServiceK<F> service;

    protected MockHttpServerK(com.sun.net.httpserver.HttpServer server, Monad<F> monad, ResponseInterpreterK<F> interpreter) {
        this.server = Objects.requireNonNull(server);
        this.monad = Objects.requireNonNull(monad);
        this.interpreter = Objects.requireNonNull(interpreter);
        this.service = new HttpServiceK("root", monad);
        this.context = server.createContext(ROOT, this::handle);
    }

    @Override
    public int getPort() {
        return this.server.getAddress().getPort();
    }

    @Override
    public String getPath() {
        return this.context.getPath();
    }

    public Monad<F> monad() {
        return this.monad;
    }

    public MockHttpServerK<F> mount(String path, HttpServiceK<F> other) {
        this.service = this.service.mount(path, other);
        return this;
    }

    public MockHttpServerK<F> exec(RequestHandlerK<F> handler) {
        this.service = this.service.exec(handler);
        return this;
    }

    public HttpRouteBuilderK.ThenStepK<F, MockHttpServerK<F>> when(Matcher1<HttpRequest> matcher) {
        return new HttpRouteBuilderK.ThenStepK(this.monad, handler -> this.addMapping(matcher, (RequestHandlerK<F>)handler));
    }

    public HttpRouteBuilderK.ThenStepK<F, MockHttpServerK<F>> preFilter(Matcher1<HttpRequest> matcher) {
        return new HttpRouteBuilderK.ThenStepK(this.monad, handler -> this.addPreFilter(matcher, (RequestHandlerK<F>)handler));
    }

    public MockHttpServerK<F> preFilter(PreFilterK<F> filter) {
        this.service = this.service.preFilter(filter);
        return this;
    }

    public MockHttpServerK<F> postFilter(PostFilterK<F> filter) {
        this.service = this.service.postFilter(filter);
        return this;
    }

    @Override
    public MockHttpServerK<F> start() {
        this.server.start();
        LOG.info("server listening at {}", (Object)this.server.getAddress());
        return this;
    }

    @Override
    public void stop() {
        this.server.stop(0);
        LOG.info("server stopped");
    }

    @Override
    public MockHttpServerK<F> verify(Matcher1<HttpRequest> matcher) {
        if (!this.matches(matcher)) {
            throw new AssertionError((Object)"request not found");
        }
        return this;
    }

    @Override
    public MockHttpServerK<F> verify(Matcher1<HttpRequest> matcher, int times) {
        int count = this.count(matcher);
        if (count != times) {
            throw new AssertionError((Object)("expected to match for " + times + " times, but was called " + count + " times"));
        }
        return this;
    }

    @Override
    public MockHttpServerK<F> verifyNot(Matcher1<HttpRequest> matcher) {
        if (this.matches(matcher)) {
            throw new AssertionError((Object)"request not found");
        }
        return this;
    }

    @Override
    public Sequence<HttpRequest> getUnmatched() {
        return ImmutableList.from(this.unmatched.values());
    }

    @Override
    public void reset() {
        this.service = new HttpServiceK("root", this.monad);
        this.matched.clear();
        this.unmatched.clear();
    }

    protected MockHttpServerK<F> addMapping(Matcher1<HttpRequest> matcher, RequestHandlerK<F> handler) {
        this.service = this.service.addMapping(matcher, handler);
        return this;
    }

    protected MockHttpServerK<F> addPreFilter(Matcher1<HttpRequest> matcher, RequestHandlerK<F> handler) {
        this.service = this.service.addPreFilter(matcher, handler);
        return this;
    }

    private void handle(HttpExchange exchange) throws IOException {
        HttpRequest request = this.createRequest(exchange);
        try {
            Kind response = this.monad.map(this.execute(request), option -> this.fold(request, (Option<HttpResponse>)option));
            this.interpreter.run(response).onSuccess(res -> this.processResponse(exchange, (HttpResponse)res)).onFailure(err -> this.processResponse(exchange, Responses.error((Throwable)err)));
        }
        catch (Exception e) {
            this.processResponse(exchange, Responses.error((Throwable)e));
        }
    }

    private HttpResponse fold(HttpRequest request, Option<HttpResponse> option) {
        return (HttpResponse)option.ifPresent(response -> this.matched(request)).ifEmpty(() -> this.unmatched(request)).getOrElse(Responses::notFound);
    }

    private void unmatched(HttpRequest request) {
        LOG.debug("unmatched request {}", (Object)request);
        this.unmatched.put(Instant.now(), request);
    }

    private void matched(HttpRequest request) {
        this.matched.put(Instant.now(), request);
    }

    private boolean matches(Matcher1<HttpRequest> matcher) {
        return this.matched.values().stream().anyMatch(arg_0 -> matcher.match(arg_0));
    }

    private int count(Matcher1<HttpRequest> matcher) {
        return (int)this.matched.values().stream().filter(arg_0 -> matcher.match(arg_0)).count();
    }

    private Kind<F, Option<HttpResponse>> execute(HttpRequest request) {
        return this.service.execute(request);
    }

    private HttpRequest createRequest(HttpExchange exchange) throws IOException {
        HttpMethod method = HttpMethod.valueOf((String)exchange.getRequestMethod());
        HttpHeaders headers = HttpHeaders.from((Map)exchange.getRequestHeaders());
        HttpParams params = new HttpParams(exchange.getRequestURI().getQuery());
        HttpPath path = HttpPath.from((String)exchange.getRequestURI().getPath());
        Bytes body = Bytes.asBytes((InputStream)exchange.getRequestBody());
        return new HttpRequest(method, path, body, headers, params);
    }

    private void processResponse(HttpExchange exchange, HttpResponse response) {
        try (HttpExchange httpExchange = exchange;){
            Bytes bytes = response.body();
            response.headers().forEach((key, value) -> exchange.getResponseHeaders().add((String)key, (String)value));
            exchange.sendResponseHeaders(response.status().code(), bytes.size());
            try (OutputStream output = exchange.getResponseBody();){
                output.write(bytes.toArray());
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static final class LimitedSizeMap<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = 1L;
        private final int maxSize;

        private LimitedSizeMap(int maxSize) {
            super(maxSize);
            this.maxSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.maxSize;
        }
    }

    public static final class Builder {
        private String host = "localhost";
        private int port = 8080;
        private int backlog = 0;
        @Nullable
        private Executor executor;

        public Builder host(String host) {
            this.host = Objects.requireNonNull(host);
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder backlog(int backlog) {
            this.backlog = backlog;
            return this;
        }

        public Builder executor(Executor executor) {
            this.executor = executor;
            return this;
        }

        public com.sun.net.httpserver.HttpServer build() {
            try {
                com.sun.net.httpserver.HttpServer server = com.sun.net.httpserver.HttpServer.create(new InetSocketAddress(this.host, this.port), this.backlog);
                if (this.executor != null) {
                    server.setExecutor(this.executor);
                } else {
                    server.setExecutor(Executors.newVirtualThreadPerTaskExecutor());
                }
                return server;
            }
            catch (IOException e) {
                throw new UncheckedIOException("unable to create server at " + this.host + ":" + this.port, e);
            }
        }
    }

    public static abstract class BuilderK<F extends Kind<F, ?>, T extends HttpServer> {
        private final Monad<F> monad;
        private final ResponseInterpreterK<F> interpreter;
        private final Builder builder = new Builder();

        protected BuilderK(Monad<F> monad, ResponseInterpreterK<F> interpreter) {
            this.monad = Objects.requireNonNull(monad);
            this.interpreter = Objects.requireNonNull(interpreter);
        }

        public BuilderK<F, T> host(String host) {
            this.builder.host(host);
            return this;
        }

        public BuilderK<F, T> port(int port) {
            this.builder.port(port);
            return this;
        }

        public BuilderK<F, T> executor(Executor executor) {
            this.builder.executor(executor);
            return this;
        }

        public BuilderK<F, T> backlog(int backlog) {
            this.builder.backlog(backlog);
            return this;
        }

        public MockHttpServerK<F> buildK() {
            return new MockHttpServerK<F>(this.builder.build(), this.monad, this.interpreter);
        }

        public abstract T build();
    }
}

