/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.zeromock.server;

import com.github.tonivade.purefun.Kind;
import com.github.tonivade.purefun.core.Matcher1;
import com.github.tonivade.purefun.data.Sequence;
import com.github.tonivade.purefun.effect.UIO;
import com.github.tonivade.purefun.typeclasses.Instances;
import com.github.tonivade.zeromock.api.HttpRequest;
import com.github.tonivade.zeromock.api.HttpRouteBuilderK;
import com.github.tonivade.zeromock.api.HttpUIOService;
import com.github.tonivade.zeromock.api.PostFilter;
import com.github.tonivade.zeromock.api.PostFilterK;
import com.github.tonivade.zeromock.api.PreFilter;
import com.github.tonivade.zeromock.api.PreFilterK;
import com.github.tonivade.zeromock.api.RequestHandlerK;
import com.github.tonivade.zeromock.server.HttpServer;
import com.github.tonivade.zeromock.server.MockHttpServerK;
import com.github.tonivade.zeromock.server.ResponseInterpreterK;
import java.util.Objects;

public final class UIOMockHttpServer
implements HttpServer,
HttpRouteBuilderK<UIO<?>, UIOMockHttpServer> {
    private final MockHttpServerK<UIO<?>> serverK;

    public UIOMockHttpServer(com.sun.net.httpserver.HttpServer server) {
        this(new MockHttpServerK(server, Instances.monad((Kind[])new UIO[0]), ResponseInterpreterK.uio()));
    }

    private UIOMockHttpServer(MockHttpServerK<UIO<?>> serverK) {
        this.serverK = Objects.requireNonNull(serverK);
    }

    @Override
    public int getPort() {
        return this.serverK.getPort();
    }

    @Override
    public String getPath() {
        return this.serverK.getPath();
    }

    public static MockHttpServerK.BuilderK<UIO<?>, UIOMockHttpServer> builder() {
        return UIOMockHttpServer.builder(ResponseInterpreterK.uio());
    }

    public static UIOMockHttpServer listenAtRandomPort() {
        return UIOMockHttpServer.listenAt(0);
    }

    public static UIOMockHttpServer listenAt(int port) {
        return UIOMockHttpServer.builder().port(port).build();
    }

    public static UIOMockHttpServer listenAt(String host, int port) {
        return UIOMockHttpServer.builder().host(host).port(port).build();
    }

    public UIOMockHttpServer mount(String path, HttpUIOService other) {
        this.serverK.mount(path, other.build());
        return this;
    }

    public UIOMockHttpServer exec(RequestHandlerK<UIO<?>> handler) {
        this.serverK.exec(handler);
        return this;
    }

    public HttpRouteBuilderK.ThenStepK<UIO<?>, UIOMockHttpServer> preFilter(Matcher1<HttpRequest> matcher) {
        return new HttpRouteBuilderK.ThenStepK(this.serverK.monad(), handler -> this.addPreFilter(matcher, (RequestHandlerK<UIO<?>>)handler));
    }

    public UIOMockHttpServer preFilter(PreFilter filter) {
        return this.preFilter(filter.lift(this.serverK.monad()));
    }

    public UIOMockHttpServer preFilter(PreFilterK<UIO<?>> filter) {
        this.serverK.preFilter(filter);
        return this;
    }

    public UIOMockHttpServer postFilter(PostFilter filter) {
        return this.postFilter(filter.lift(this.serverK.monad()));
    }

    public UIOMockHttpServer postFilter(PostFilterK<UIO<?>> filter) {
        this.serverK.postFilter(filter);
        return this;
    }

    public UIOMockHttpServer addMapping(Matcher1<HttpRequest> matcher, RequestHandlerK<UIO<?>> handler) {
        this.serverK.addMapping(matcher, handler);
        return this;
    }

    public UIOMockHttpServer addPreFilter(Matcher1<HttpRequest> matcher, RequestHandlerK<UIO<?>> handler) {
        this.serverK.preFilter(PreFilterK.filter(this.serverK.monad(), matcher, handler));
        return this;
    }

    public HttpRouteBuilderK.ThenStepK<UIO<?>, UIOMockHttpServer> when(Matcher1<HttpRequest> matcher) {
        return new HttpRouteBuilderK.ThenStepK(this.serverK.monad(), handler -> this.addMapping(matcher, (RequestHandlerK<UIO<?>>)handler));
    }

    @Override
    public UIOMockHttpServer start() {
        this.serverK.start();
        return this;
    }

    @Override
    public void stop() {
        this.serverK.stop();
    }

    @Override
    public UIOMockHttpServer verify(Matcher1<HttpRequest> matcher) {
        this.serverK.verify((Matcher1)matcher);
        return this;
    }

    @Override
    public UIOMockHttpServer verify(Matcher1<HttpRequest> matcher, int times) {
        this.serverK.verify((Matcher1)matcher, times);
        return this;
    }

    @Override
    public UIOMockHttpServer verifyNot(Matcher1<HttpRequest> matcher) {
        this.serverK.verifyNot((Matcher1)matcher);
        return this;
    }

    @Override
    public Sequence<HttpRequest> getUnmatched() {
        return this.serverK.getUnmatched();
    }

    @Override
    public void reset() {
        this.serverK.reset();
    }

    private static MockHttpServerK.BuilderK<UIO<?>, UIOMockHttpServer> builder(ResponseInterpreterK<UIO<?>> interpreter) {
        return new MockHttpServerK.BuilderK<UIO<?>, UIOMockHttpServer>(Instances.monad((Kind[])new UIO[0]), (ResponseInterpreterK)interpreter){

            @Override
            public UIOMockHttpServer build() {
                return new UIOMockHttpServer(this.buildK());
            }
        };
    }
}

