/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.decoder;

import android.content.res.XmlResourceParser;
import android.util.TypedValue;
import brut.androlib.AndrolibException;
import brut.androlib.res.decoder.ResAttrDecoder;
import brut.androlib.res.decoder.StringBlock;
import brut.androlib.res.xml.ResXmlEncoders;
import brut.util.ExtDataInput;
import com.mindprod.ledatastream.LEDataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class AXmlResourceParser
implements XmlResourceParser {
    private ExtDataInput m_reader;
    private ResAttrDecoder mAttrDecoder = new ResAttrDecoder();
    private AndrolibException mFirstError;
    private boolean m_operational = false;
    private StringBlock m_strings;
    private int[] m_resourceIDs;
    private NamespaceStack m_namespaces = new NamespaceStack();
    private boolean m_decreaseDepth;
    private int m_event;
    private int m_lineNumber;
    private int m_name;
    private int m_namespaceUri;
    private int[] m_attributes;
    private int m_idAttribute;
    private int m_classAttribute;
    private int m_styleAttribute;
    private static final Logger LOGGER = Logger.getLogger(AXmlResourceParser.class.getName());
    private static final String E_NOT_SUPPORTED = "Method is not supported.";
    private static final int ATTRIBUTE_IX_NAMESPACE_URI = 0;
    private static final int ATTRIBUTE_IX_NAME = 1;
    private static final int ATTRIBUTE_IX_VALUE_STRING = 2;
    private static final int ATTRIBUTE_IX_VALUE_TYPE = 3;
    private static final int ATTRIBUTE_IX_VALUE_DATA = 4;
    private static final int ATTRIBUTE_LENGHT = 5;
    private static final int CHUNK_AXML_FILE = 524291;
    private static final int CHUNK_RESOURCEIDS = 524672;
    private static final int CHUNK_XML_FIRST = 0x100100;
    private static final int CHUNK_XML_START_NAMESPACE = 0x100100;
    private static final int CHUNK_XML_END_NAMESPACE = 0x100101;
    private static final int CHUNK_XML_START_TAG = 0x100102;
    private static final int CHUNK_XML_END_TAG = 0x100103;
    private static final int CHUNK_XML_TEXT = 0x100104;
    private static final int CHUNK_XML_LAST = 0x100104;

    public AXmlResourceParser() {
        this.resetEventInfo();
    }

    public AXmlResourceParser(InputStream inputStream) {
        this();
        this.open(inputStream);
    }

    public AndrolibException getFirstError() {
        return this.mFirstError;
    }

    public ResAttrDecoder getAttrDecoder() {
        return this.mAttrDecoder;
    }

    public void setAttrDecoder(ResAttrDecoder resAttrDecoder) {
        this.mAttrDecoder = resAttrDecoder;
    }

    public void open(InputStream inputStream) {
        this.close();
        if (inputStream != null) {
            this.m_reader = new ExtDataInput(new LEDataInputStream(inputStream));
        }
    }

    public void close() {
        if (!this.m_operational) {
            return;
        }
        this.m_operational = false;
        this.m_reader = null;
        this.m_strings = null;
        this.m_resourceIDs = null;
        this.m_namespaces.reset();
        this.resetEventInfo();
    }

    public int next() throws XmlPullParserException, IOException {
        if (this.m_reader == null) {
            throw new XmlPullParserException("Parser is not opened.", (XmlPullParser)this, null);
        }
        try {
            this.doNext();
            return this.m_event;
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
    }

    public int nextToken() throws XmlPullParserException, IOException {
        return this.next();
    }

    public int nextTag() throws XmlPullParserException, IOException {
        int n = this.next();
        if (n == 4 && this.isWhitespace()) {
            n = this.next();
        }
        if (n != 2 && n != 3) {
            throw new XmlPullParserException("Expected start or end tag.", (XmlPullParser)this, null);
        }
        return n;
    }

    public String nextText() throws XmlPullParserException, IOException {
        if (this.getEventType() != 2) {
            throw new XmlPullParserException("Parser must be on START_TAG to read next text.", (XmlPullParser)this, null);
        }
        int n = this.next();
        if (n == 4) {
            String string = this.getText();
            n = this.next();
            if (n != 3) {
                throw new XmlPullParserException("Event TEXT must be immediately followed by END_TAG.", (XmlPullParser)this, null);
            }
            return string;
        }
        if (n == 3) {
            return "";
        }
        throw new XmlPullParserException("Parser must be on START_TAG or TEXT to read text.", (XmlPullParser)this, null);
    }

    public void require(int n, String string, String string2) throws XmlPullParserException, IOException {
        if (n != this.getEventType() || string != null && !string.equals(this.getNamespace()) || string2 != null && !string2.equals(this.getName())) {
            throw new XmlPullParserException(TYPES[n] + " is expected.", (XmlPullParser)this, null);
        }
    }

    public int getDepth() {
        return this.m_namespaces.getDepth() - 1;
    }

    public int getEventType() throws XmlPullParserException {
        return this.m_event;
    }

    public int getLineNumber() {
        return this.m_lineNumber;
    }

    public String getName() {
        if (this.m_name == -1 || this.m_event != 2 && this.m_event != 3) {
            return null;
        }
        return this.m_strings.getString(this.m_name);
    }

    public String getText() {
        if (this.m_name == -1 || this.m_event != 4) {
            return null;
        }
        return this.m_strings.getString(this.m_name);
    }

    public char[] getTextCharacters(int[] nArray) {
        String string = this.getText();
        if (string == null) {
            return null;
        }
        nArray[0] = 0;
        nArray[1] = string.length();
        char[] cArray = new char[string.length()];
        string.getChars(0, string.length(), cArray, 0);
        return cArray;
    }

    public String getNamespace() {
        return this.m_strings.getString(this.m_namespaceUri);
    }

    public String getPrefix() {
        int n = this.m_namespaces.findPrefix(this.m_namespaceUri);
        return this.m_strings.getString(n);
    }

    public String getPositionDescription() {
        return "XML line #" + this.getLineNumber();
    }

    public int getNamespaceCount(int n) throws XmlPullParserException {
        return this.m_namespaces.getAccumulatedCount(n);
    }

    public String getNamespacePrefix(int n) throws XmlPullParserException {
        int n2 = this.m_namespaces.getPrefix(n);
        return this.m_strings.getString(n2);
    }

    public String getNamespaceUri(int n) throws XmlPullParserException {
        int n2 = this.m_namespaces.getUri(n);
        return this.m_strings.getString(n2);
    }

    public String getClassAttribute() {
        if (this.m_classAttribute == -1) {
            return null;
        }
        int n = this.getAttributeOffset(this.m_classAttribute);
        int n2 = this.m_attributes[n + 2];
        return this.m_strings.getString(n2);
    }

    public String getIdAttribute() {
        if (this.m_idAttribute == -1) {
            return null;
        }
        int n = this.getAttributeOffset(this.m_idAttribute);
        int n2 = this.m_attributes[n + 2];
        return this.m_strings.getString(n2);
    }

    public int getIdAttributeResourceValue(int n) {
        if (this.m_idAttribute == -1) {
            return n;
        }
        int n2 = this.getAttributeOffset(this.m_idAttribute);
        int n3 = this.m_attributes[n2 + 3];
        if (n3 != 1) {
            return n;
        }
        return this.m_attributes[n2 + 4];
    }

    public int getStyleAttribute() {
        if (this.m_styleAttribute == -1) {
            return 0;
        }
        int n = this.getAttributeOffset(this.m_styleAttribute);
        return this.m_attributes[n + 4];
    }

    public int getAttributeCount() {
        if (this.m_event != 2) {
            return -1;
        }
        return this.m_attributes.length / 5;
    }

    public String getAttributeNamespace(int n) {
        int n2 = this.getAttributeOffset(n);
        int n3 = this.m_attributes[n2 + 0];
        if (n3 == -1) {
            return "";
        }
        return this.m_strings.getString(n3);
    }

    public String getAttributePrefix(int n) {
        int n2 = this.getAttributeOffset(n);
        int n3 = this.m_attributes[n2 + 0];
        int n4 = this.m_namespaces.findPrefix(n3);
        if (n4 == -1) {
            return "";
        }
        return this.m_strings.getString(n4);
    }

    public String getAttributeName(int n) {
        int n2 = this.getAttributeOffset(n);
        int n3 = this.m_attributes[n2 + 1];
        if (n3 == -1) {
            return "";
        }
        return this.m_strings.getString(n3);
    }

    public int getAttributeNameResource(int n) {
        int n2 = this.getAttributeOffset(n);
        int n3 = this.m_attributes[n2 + 1];
        if (this.m_resourceIDs == null || n3 < 0 || n3 >= this.m_resourceIDs.length) {
            return 0;
        }
        return this.m_resourceIDs[n3];
    }

    public int getAttributeValueType(int n) {
        int n2 = this.getAttributeOffset(n);
        return this.m_attributes[n2 + 3];
    }

    public int getAttributeValueData(int n) {
        int n2 = this.getAttributeOffset(n);
        return this.m_attributes[n2 + 4];
    }

    public String getAttributeValue(int n) {
        int n2 = this.getAttributeOffset(n);
        int n3 = this.m_attributes[n2 + 3];
        int n4 = this.m_attributes[n2 + 4];
        int n5 = this.m_attributes[n2 + 2];
        if (this.mAttrDecoder != null) {
            try {
                return this.mAttrDecoder.decode(n3, n4, n5 == -1 ? null : ResXmlEncoders.escapeXmlChars(this.m_strings.getString(n5)), this.getAttributeNameResource(n));
            }
            catch (AndrolibException androlibException) {
                this.setFirstError(androlibException);
                LOGGER.log(Level.WARNING, String.format("Could not decode attr value, using undecoded value instead: ns=%s, name=%s, value=0x%08x", this.getAttributePrefix(n), this.getAttributeName(n), n4), androlibException);
            }
        }
        return TypedValue.coerceToString((int)n3, (int)n4);
    }

    public boolean getAttributeBooleanValue(int n, boolean bl) {
        return this.getAttributeIntValue(n, bl ? 1 : 0) != 0;
    }

    public float getAttributeFloatValue(int n, float f) {
        int n2 = this.getAttributeOffset(n);
        int n3 = this.m_attributes[n2 + 3];
        if (n3 == 4) {
            int n4 = this.m_attributes[n2 + 4];
            return Float.intBitsToFloat(n4);
        }
        return f;
    }

    public int getAttributeIntValue(int n, int n2) {
        int n3 = this.getAttributeOffset(n);
        int n4 = this.m_attributes[n3 + 3];
        if (n4 >= 16 && n4 <= 31) {
            return this.m_attributes[n3 + 4];
        }
        return n2;
    }

    public int getAttributeUnsignedIntValue(int n, int n2) {
        return this.getAttributeIntValue(n, n2);
    }

    public int getAttributeResourceValue(int n, int n2) {
        int n3 = this.getAttributeOffset(n);
        int n4 = this.m_attributes[n3 + 3];
        if (n4 == 1) {
            return this.m_attributes[n3 + 4];
        }
        return n2;
    }

    public String getAttributeValue(String string, String string2) {
        int n = this.findAttribute(string, string2);
        if (n == -1) {
            return null;
        }
        return this.getAttributeValue(n);
    }

    public boolean getAttributeBooleanValue(String string, String string2, boolean bl) {
        int n = this.findAttribute(string, string2);
        if (n == -1) {
            return bl;
        }
        return this.getAttributeBooleanValue(n, bl);
    }

    public float getAttributeFloatValue(String string, String string2, float f) {
        int n = this.findAttribute(string, string2);
        if (n == -1) {
            return f;
        }
        return this.getAttributeFloatValue(n, f);
    }

    public int getAttributeIntValue(String string, String string2, int n) {
        int n2 = this.findAttribute(string, string2);
        if (n2 == -1) {
            return n;
        }
        return this.getAttributeIntValue(n2, n);
    }

    public int getAttributeUnsignedIntValue(String string, String string2, int n) {
        int n2 = this.findAttribute(string, string2);
        if (n2 == -1) {
            return n;
        }
        return this.getAttributeUnsignedIntValue(n2, n);
    }

    public int getAttributeResourceValue(String string, String string2, int n) {
        int n2 = this.findAttribute(string, string2);
        if (n2 == -1) {
            return n;
        }
        return this.getAttributeResourceValue(n2, n);
    }

    public int getAttributeListValue(int n, String[] stringArray, int n2) {
        return 0;
    }

    public int getAttributeListValue(String string, String string2, String[] stringArray, int n) {
        return 0;
    }

    public String getAttributeType(int n) {
        return "CDATA";
    }

    public boolean isAttributeDefault(int n) {
        return false;
    }

    public void setInput(InputStream inputStream, String string) throws XmlPullParserException {
        this.open(inputStream);
    }

    public void setInput(Reader reader) throws XmlPullParserException {
        throw new XmlPullParserException(E_NOT_SUPPORTED);
    }

    public String getInputEncoding() {
        return null;
    }

    public int getColumnNumber() {
        return -1;
    }

    public boolean isEmptyElementTag() throws XmlPullParserException {
        return false;
    }

    public boolean isWhitespace() throws XmlPullParserException {
        return false;
    }

    public void defineEntityReplacementText(String string, String string2) throws XmlPullParserException {
        throw new XmlPullParserException(E_NOT_SUPPORTED);
    }

    public String getNamespace(String string) {
        throw new RuntimeException(E_NOT_SUPPORTED);
    }

    public Object getProperty(String string) {
        return null;
    }

    public void setProperty(String string, Object object) throws XmlPullParserException {
        throw new XmlPullParserException(E_NOT_SUPPORTED);
    }

    public boolean getFeature(String string) {
        return false;
    }

    public void setFeature(String string, boolean bl) throws XmlPullParserException {
        throw new XmlPullParserException(E_NOT_SUPPORTED);
    }

    final StringBlock getStrings() {
        return this.m_strings;
    }

    private final int getAttributeOffset(int n) {
        if (this.m_event != 2) {
            throw new IndexOutOfBoundsException("Current event is not START_TAG.");
        }
        int n2 = n * 5;
        if (n2 >= this.m_attributes.length) {
            throw new IndexOutOfBoundsException("Invalid attribute index (" + n + ").");
        }
        return n2;
    }

    private final int findAttribute(String string, String string2) {
        if (this.m_strings == null || string2 == null) {
            return -1;
        }
        int n = this.m_strings.find(string2);
        if (n == -1) {
            return -1;
        }
        int n2 = string != null ? this.m_strings.find(string) : -1;
        for (int i = 0; i != this.m_attributes.length; ++i) {
            if (n != this.m_attributes[i + 1] || n2 != -1 && n2 != this.m_attributes[i + 0]) continue;
            return i / 5;
        }
        return -1;
    }

    private final void resetEventInfo() {
        this.m_event = -1;
        this.m_lineNumber = -1;
        this.m_name = -1;
        this.m_namespaceUri = -1;
        this.m_attributes = null;
        this.m_idAttribute = -1;
        this.m_classAttribute = -1;
        this.m_styleAttribute = -1;
    }

    private final void doNext() throws IOException {
        block14: {
            if (this.m_strings == null) {
                this.m_reader.skipCheckInt(524291);
                this.m_reader.skipInt();
                this.m_strings = StringBlock.read(this.m_reader);
                this.m_namespaces.increaseDepth();
                this.m_operational = true;
            }
            if (this.m_event == 1) {
                return;
            }
            int n = this.m_event;
            this.resetEventInfo();
            while (true) {
                int n2;
                int n3;
                int n4;
                if (this.m_decreaseDepth) {
                    this.m_decreaseDepth = false;
                    this.m_namespaces.decreaseDepth();
                }
                if (n == 3 && this.m_namespaces.getDepth() == 1 && this.m_namespaces.getCurrentCount() == 0) {
                    this.m_event = 1;
                    break block14;
                }
                int n5 = n == 0 ? 0x100102 : this.m_reader.readInt();
                if (n5 == 524672) {
                    n4 = this.m_reader.readInt();
                    if (n4 < 8 || n4 % 4 != 0) {
                        throw new IOException("Invalid resource ids size (" + n4 + ").");
                    }
                    this.m_resourceIDs = this.m_reader.readIntArray(n4 / 4 - 2);
                    continue;
                }
                if (n5 < 0x100100 || n5 > 0x100104) {
                    throw new IOException("Invalid chunk type (" + n5 + ").");
                }
                if (n5 == 0x100102 && n == -1) {
                    this.m_event = 0;
                    break block14;
                }
                this.m_reader.skipInt();
                n4 = this.m_reader.readInt();
                this.m_reader.skipInt();
                if (n5 == 0x100100 || n5 == 0x100101) {
                    if (n5 == 0x100100) {
                        n3 = this.m_reader.readInt();
                        n2 = this.m_reader.readInt();
                        this.m_namespaces.push(n3, n2);
                        continue;
                    }
                    this.m_reader.skipInt();
                    this.m_reader.skipInt();
                    this.m_namespaces.pop();
                    continue;
                }
                this.m_lineNumber = n4;
                if (n5 == 0x100102) {
                    this.m_namespaceUri = this.m_reader.readInt();
                    this.m_name = this.m_reader.readInt();
                    this.m_reader.skipInt();
                    n3 = this.m_reader.readInt();
                    this.m_idAttribute = (n3 >>> 16) - 1;
                    this.m_classAttribute = this.m_reader.readInt();
                    this.m_styleAttribute = (this.m_classAttribute >>> 16) - 1;
                    this.m_classAttribute = (this.m_classAttribute & 0xFFFF) - 1;
                    this.m_attributes = this.m_reader.readIntArray((n3 &= 0xFFFF) * 5);
                    for (n2 = 3; n2 < this.m_attributes.length; n2 += 5) {
                        this.m_attributes[n2] = this.m_attributes[n2] >>> 24;
                    }
                    this.m_namespaces.increaseDepth();
                    this.m_event = 2;
                    break block14;
                }
                if (n5 == 0x100103) {
                    this.m_namespaceUri = this.m_reader.readInt();
                    this.m_name = this.m_reader.readInt();
                    this.m_event = 3;
                    this.m_decreaseDepth = true;
                    break block14;
                }
                if (n5 == 0x100104) break;
            }
            this.m_name = this.m_reader.readInt();
            this.m_reader.skipInt();
            this.m_reader.skipInt();
            this.m_event = 4;
        }
    }

    private void setFirstError(AndrolibException androlibException) {
        if (this.mFirstError == null) {
            this.mFirstError = androlibException;
        }
    }

    private static final class NamespaceStack {
        private int[] m_data = new int[32];
        private int m_dataLength;
        private int m_count;
        private int m_depth;

        public final void reset() {
            this.m_dataLength = 0;
            this.m_count = 0;
            this.m_depth = 0;
        }

        public final int getTotalCount() {
            return this.m_count;
        }

        public final int getCurrentCount() {
            if (this.m_dataLength == 0) {
                return 0;
            }
            int n = this.m_dataLength - 1;
            return this.m_data[n];
        }

        public final int getAccumulatedCount(int n) {
            if (this.m_dataLength == 0 || n < 0) {
                return 0;
            }
            if (n > this.m_depth) {
                n = this.m_depth;
            }
            int n2 = 0;
            int n3 = 0;
            while (n != 0) {
                int n4 = this.m_data[n3];
                n2 += n4;
                n3 += 2 + n4 * 2;
                --n;
            }
            return n2;
        }

        public final void push(int n, int n2) {
            if (this.m_depth == 0) {
                this.increaseDepth();
            }
            this.ensureDataCapacity(2);
            int n3 = this.m_dataLength - 1;
            int n4 = this.m_data[n3];
            this.m_data[n3 - 1 - n4 * 2] = n4 + 1;
            this.m_data[n3] = n;
            this.m_data[n3 + 1] = n2;
            this.m_data[n3 + 2] = n4 + 1;
            this.m_dataLength += 2;
            ++this.m_count;
        }

        public final boolean pop(int n, int n2) {
            if (this.m_dataLength == 0) {
                return false;
            }
            int n3 = this.m_dataLength - 1;
            int n4 = this.m_data[n3];
            int n5 = 0;
            int n6 = n3 - 2;
            while (n5 != n4) {
                if (this.m_data[n6] == n && this.m_data[n6 + 1] == n2) {
                    --n4;
                    if (n5 == 0) {
                        this.m_data[n6] = n4;
                        this.m_data[n6 -= 1 + n4 * 2] = n4;
                    } else {
                        this.m_data[n3] = n4;
                        this.m_data[n3 -= 3 + n4 * 2] = n4;
                        System.arraycopy(this.m_data, n6 + 2, this.m_data, n6, this.m_dataLength - n6);
                    }
                    this.m_dataLength -= 2;
                    --this.m_count;
                    return true;
                }
                ++n5;
                n6 -= 2;
            }
            return false;
        }

        public final boolean pop() {
            if (this.m_dataLength == 0) {
                return false;
            }
            int n = this.m_dataLength - 1;
            int n2 = this.m_data[n];
            if (n2 == 0) {
                return false;
            }
            this.m_data[n -= 2] = --n2;
            this.m_data[n -= 1 + n2 * 2] = n2;
            this.m_dataLength -= 2;
            --this.m_count;
            return true;
        }

        public final int getPrefix(int n) {
            return this.get(n, true);
        }

        public final int getUri(int n) {
            return this.get(n, false);
        }

        public final int findPrefix(int n) {
            return this.find(n, false);
        }

        public final int findUri(int n) {
            return this.find(n, true);
        }

        public final int getDepth() {
            return this.m_depth;
        }

        public final void increaseDepth() {
            this.ensureDataCapacity(2);
            int n = this.m_dataLength;
            this.m_data[n] = 0;
            this.m_data[n + 1] = 0;
            this.m_dataLength += 2;
            ++this.m_depth;
        }

        public final void decreaseDepth() {
            if (this.m_dataLength == 0) {
                return;
            }
            int n = this.m_dataLength - 1;
            int n2 = this.m_data[n];
            if (n - 1 - n2 * 2 == 0) {
                return;
            }
            this.m_dataLength -= 2 + n2 * 2;
            this.m_count -= n2;
            --this.m_depth;
        }

        private void ensureDataCapacity(int n) {
            int n2 = this.m_data.length - this.m_dataLength;
            if (n2 > n) {
                return;
            }
            int n3 = (this.m_data.length + n2) * 2;
            int[] nArray = new int[n3];
            System.arraycopy(this.m_data, 0, nArray, 0, this.m_dataLength);
            this.m_data = nArray;
        }

        private final int find(int n, boolean bl) {
            if (this.m_dataLength == 0) {
                return -1;
            }
            int n2 = this.m_dataLength - 1;
            for (int i = this.m_depth; i != 0; --i) {
                int n3 = this.m_data[n2];
                n2 -= 2;
                while (n3 != 0) {
                    if (bl) {
                        if (this.m_data[n2] == n) {
                            return this.m_data[n2 + 1];
                        }
                    } else if (this.m_data[n2 + 1] == n) {
                        return this.m_data[n2];
                    }
                    n2 -= 2;
                    --n3;
                }
            }
            return -1;
        }

        private final int get(int n, boolean bl) {
            if (this.m_dataLength == 0 || n < 0) {
                return -1;
            }
            int n2 = 0;
            for (int i = this.m_depth; i != 0; --i) {
                int n3 = this.m_data[n2];
                if (n >= n3) {
                    n -= n3;
                    n2 += 2 + n3 * 2;
                    continue;
                }
                n2 += 1 + n * 2;
                if (!bl) {
                    ++n2;
                }
                return this.m_data[n2];
            }
            return -1;
        }
    }
}

