/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic;

import ch.qos.logback.classic.android.BasicLogcatConfigurator;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeadlockTest {
    private static final Logger log = LoggerFactory.getLogger(DeadlockTest.class);

    @Test
    public void noDeadlock() throws InterruptedException {
        this.startThreads();
        Thread.sleep(4000L);
        Assert.assertThat((Object)this.deadlockExists(), (Matcher)CoreMatchers.is((Object)false));
    }

    private boolean deadlockExists() {
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        long[] threadIds = bean.findDeadlockedThreads();
        if (threadIds != null) {
            ThreadInfo[] infos;
            for (ThreadInfo info : infos = bean.getThreadInfo(threadIds)) {
                StackTraceElement[] stackTraceElementArray = info.getStackTrace();
            }
        }
        return threadIds != null;
    }

    private void startThreads() {
        final A a = new A();
        a.setName("BAR");
        new Thread("T1"){

            public void run() {
                log.info("Thread 1 start");
                int count = 0;
                while (true) {
                    a.doStuff(++count);
                }
            }
        }.start();
        new Thread("T2"){

            public void run() {
                log.info("Thread 2 start");
                int count = 0;
                while (true) {
                    log.debug("T2 count={} a={}", (Object)(++count), (Object)a);
                }
            }
        }.start();
    }

    static {
        BasicLogcatConfigurator.configureDefaultContext();
    }

    public static class A {
        private String mName;

        public synchronized String getName() {
            return this.mName;
        }

        public synchronized void setName(String name) {
            this.mName = name;
        }

        public String toString() {
            return "My name is " + this.getName();
        }

        public synchronized void doStuff(int count) {
            log.debug("A is doing some synchronized stuff, count={}", (Object)count);
        }
    }
}

