/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.pattern.ConverterTest;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.pattern.FormattingConverter;
import ch.qos.logback.core.pattern.PatternLayoutBase;
import ch.qos.logback.core.pattern.parser.AbstractPatternLayoutBaseTest;
import ch.qos.logback.core.spi.PropertyContainer;
import ch.qos.logback.core.testUtil.StringListAppender;
import ch.qos.logback.core.util.OptionHelper;
import ch.qos.logback.core.util.StatusPrinter;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.MDC;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternLayoutTest
extends AbstractPatternLayoutBaseTest<ILoggingEvent> {
    private PatternLayout pl = new PatternLayout();
    private LoggerContext lc = new LoggerContext();
    Logger logger = this.lc.getLogger(ConverterTest.class);
    Logger root = this.lc.getLogger("ROOT");
    ILoggingEvent le;

    public PatternLayoutTest() {
        Exception ex = new Exception("Bogus exception");
        this.le = this.makeLoggingEvent(ex);
    }

    @Before
    public void setUp() {
        this.pl.setContext((Context)this.lc);
    }

    ILoggingEvent makeLoggingEvent(Exception ex) {
        return new LoggingEvent(FormattingConverter.class.getName(), this.logger, Level.INFO, "Some message", (Throwable)ex, null);
    }

    public ILoggingEvent getEventObject() {
        return this.makeLoggingEvent(null);
    }

    public PatternLayoutBase<ILoggingEvent> getPatternLayoutBase() {
        return new PatternLayout();
    }

    @Test
    public void testOK() {
        this.pl.setPattern("%d %le [%t] %lo{30} - %m%n");
        this.pl.start();
        String val = this.pl.doLayout(this.getEventObject());
        String regex = "\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2},\\d{3} INFO \\[.+\\] c.q.l.c.pattern.ConverterTest - Some message\\s*";
        Assert.assertThat((Object)val, (Matcher)Matchers.matchesPattern((String)regex));
    }

    @Test
    public void testNoExeptionHandler() {
        this.pl.setPattern("%m%n");
        this.pl.start();
        String val = this.pl.doLayout(this.le);
        Assert.assertThat((Object)val, (Matcher)Matchers.containsString((String)"java.lang.Exception: Bogus exception"));
    }

    @Test
    public void testCompositePattern() {
        this.pl.setPattern("%-56(%d %lo{20}) - %m%n");
        this.pl.start();
        String val = this.pl.doLayout(this.getEventObject());
        String regex = "\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2},\\d{3} c.q.l.c.p.ConverterTest          - Some message\\s*";
        Assert.assertThat((Object)val, (Matcher)Matchers.matchesPattern((String)regex));
    }

    @Test
    public void contextProperty() {
        this.pl.setPattern("%property{a}");
        this.pl.start();
        this.lc.putProperty("a", "b");
        String val = this.pl.doLayout(this.getEventObject());
        junit.framework.Assert.assertEquals((String)"b", (String)val);
    }

    @Test
    public void testNopExeptionHandler() {
        this.pl.setPattern("%nopex %m%n");
        this.pl.start();
        String val = this.pl.doLayout(this.le);
        Assert.assertThat((Object)val, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"java.lang.Exception: Bogus exception")));
    }

    @Test
    public void testWithParenthesis() {
        this.pl.setPattern("\\(%msg:%msg\\) %msg");
        this.pl.start();
        this.le = this.makeLoggingEvent(null);
        String val = this.pl.doLayout(this.le);
        junit.framework.Assert.assertEquals((String)"(Some message:Some message) Some message", (String)val);
    }

    @Test
    public void testWithLettersComingFromLog4j() {
        this.pl.setPattern("%d %p [%t] %c{30} - %m%n");
        this.pl.start();
        String val = this.pl.doLayout(this.getEventObject());
        String regex = "\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2},\\d{3} INFO \\[.+\\] c.q.l.c.pattern.ConverterTest - Some message\\s*";
        Assert.assertThat((Object)val, (Matcher)Matchers.matchesPattern((String)regex));
    }

    @Test
    public void mdcWithDefaultValue() {
        String pattern = "%msg %mdc{foo} %mdc{bar:-[null]}";
        this.pl.setPattern(OptionHelper.substVars((String)pattern, (PropertyContainer)this.lc));
        this.pl.start();
        MDC.put((String)"foo", (String)"foo");
        try {
            String val = this.pl.doLayout(this.getEventObject());
            junit.framework.Assert.assertEquals((String)"Some message foo [null]", (String)val);
        }
        finally {
            MDC.remove((String)"foo");
        }
    }

    @Test
    public void contextNameTest() {
        this.pl.setPattern("%contextName");
        this.lc.setName("aValue");
        this.pl.start();
        String val = this.pl.doLayout(this.getEventObject());
        junit.framework.Assert.assertEquals((String)"aValue", (String)val);
    }

    @Test
    public void cnTest() {
        this.pl.setPattern("%cn");
        this.lc.setName("aValue");
        this.pl.start();
        String val = this.pl.doLayout(this.getEventObject());
        junit.framework.Assert.assertEquals((String)"aValue", (String)val);
    }

    public Context getContext() {
        return this.lc;
    }

    void configure(String file) throws JoranException {
        JoranConfigurator jc = new JoranConfigurator();
        jc.setContext((Context)this.lc);
        jc.doConfigure(file);
    }

    @Test
    public void testConversionRuleSupportInPatternLayout() throws JoranException {
        this.configure("src/test/input/joran/conversionRule/patternLayout0.xml");
        this.root.getAppender("LIST");
        String msg = "Simon says";
        this.logger.debug(msg);
        StringListAppender sla = (StringListAppender)this.root.getAppender("LIST");
        junit.framework.Assert.assertNotNull((Object)sla);
        junit.framework.Assert.assertEquals((int)1, (int)sla.strList.size());
        junit.framework.Assert.assertEquals((String)("sample - " + msg), (String)((String)sla.strList.get(0)));
    }

    @Test
    public void somekeReplace() {
        this.pl.setPattern("%replace(a1234b){'\\d{4}', 'XXXX'}");
        this.pl.start();
        StatusPrinter.print((Context)this.lc);
        String val = this.pl.doLayout(this.getEventObject());
        junit.framework.Assert.assertEquals((String)"aXXXXb", (String)val);
    }

    @Test
    public void replaceWithJoran() throws JoranException {
        this.configure("src/test/input/joran/pattern/replace0.xml");
        StatusPrinter.print((Context)this.lc);
        this.root.getAppender("LIST");
        String msg = "And the number is 4111111111110000, expiring on 12/2010";
        this.logger.debug(msg);
        StringListAppender sla = (StringListAppender)this.root.getAppender("LIST");
        junit.framework.Assert.assertNotNull((Object)sla);
        junit.framework.Assert.assertEquals((int)1, (int)sla.strList.size());
        junit.framework.Assert.assertEquals((String)"And the number is XXXX, expiring on 12/2010", (String)((String)sla.strList.get(0)));
    }
}

