/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.control.ControlLogger;
import ch.qos.logback.classic.control.ControlLoggerContext;
import ch.qos.logback.classic.control.CreateLogger;
import ch.qos.logback.classic.control.Scenario;
import ch.qos.logback.classic.control.ScenarioAction;
import ch.qos.logback.classic.control.ScenarioMaker;
import ch.qos.logback.classic.control.SetLevel;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class ScenarioBasedLoggerContextTest {
    LoggerContext lc;

    @Test
    public void testLen3() {
        this.doScenarioedTest(3);
    }

    @Test
    public void testLength_30() {
        this.doScenarioedTest(30);
    }

    @Test
    public void testLength_20000() {
        this.doScenarioedTest(20000);
    }

    @Test
    @Ignore
    public void testLengthLong() {
        this.doScenarioedTest(100000);
    }

    private void doScenarioedTest(int len) {
        LoggerContext lc = new LoggerContext();
        ControlLoggerContext controlContext = new ControlLoggerContext();
        Scenario s = ScenarioMaker.makeRealisticCreationScenario(len);
        List<ScenarioAction> actionList = s.getActionList();
        int size = actionList.size();
        for (int i = 0; i < size; ++i) {
            ScenarioAction action = actionList.get(i);
            if (action instanceof CreateLogger) {
                CreateLogger cl = (CreateLogger)action;
                lc.getLogger(cl.getLoggerName());
                controlContext.getLogger(cl.getLoggerName());
                continue;
            }
            if (!(action instanceof SetLevel)) continue;
            SetLevel sl = (SetLevel)action;
            Logger l = lc.getLogger(sl.getLoggerName());
            ControlLogger controlLogger = controlContext.getLogger(sl.getLoggerName());
            l.setLevel(sl.getLevel());
            controlLogger.setLevel(sl.getLevel());
        }
        this.compareLoggerContexts(controlContext, lc);
    }

    void compareLoggerContexts(ControlLoggerContext controlLC, LoggerContext lc) {
        Map<String, ControlLogger> controlLoggerMap = controlLC.getLoggerMap();
        Assert.assertEquals((int)(controlLoggerMap.size() + 1), (int)lc.size());
        for (String loggerName : controlLoggerMap.keySet()) {
            Logger logger = lc.exists(loggerName);
            ControlLogger controlLogger = controlLoggerMap.get(loggerName);
            if (logger == null) {
                throw new IllegalStateException("logger" + loggerName + " should exist");
            }
            Assert.assertEquals((String)loggerName, (String)logger.getName());
            Assert.assertEquals((String)loggerName, (String)controlLogger.getName());
            this.compareLoggers(controlLogger, logger);
        }
    }

    void compareLoggers(ControlLogger controlLogger, Logger logger) {
        Assert.assertEquals((String)controlLogger.getName(), (String)logger.getName());
        Assert.assertEquals((Object)controlLogger.getEffectiveLevel(), (Object)logger.getEffectiveLevel());
        Level controlLevel = controlLogger.getLevel();
        Level level = logger.getLevel();
        if (controlLevel == null) {
            Assert.assertNull((Object)level);
        } else {
            Assert.assertEquals((Object)controlLevel, (Object)level);
        }
    }
}

