/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.android;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.TrivialConfigurator;
import ch.qos.logback.core.joran.action.NOPAction;
import ch.qos.logback.core.joran.action.ext.StackAction;
import ch.qos.logback.core.joran.spi.ElementSelector;
import ch.qos.logback.core.joran.spi.JoranException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Stack;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AndroidManifestPropertiesUtilTest {
    private static final String PACKAGE_VAL = "android";
    private static final String VERSION_NAME_VAL = "2.1";
    private static final String VERSION_CODE_VAL = "";
    private static final String EXT_DIR_VAL = "/mnt/sdcard";
    private static final String DATA_DIR_VAL = "/data/data/android/files";
    private static Context context = new LoggerContext();
    private TrivialConfigurator tc;
    private StackAction stackAction;

    @Before
    public void setup() {
        HashMap<ElementSelector, Object> rulesMap = new HashMap<ElementSelector, Object>();
        rulesMap.put(new ElementSelector("x"), new NOPAction());
        this.stackAction = new StackAction();
        rulesMap.put(new ElementSelector("x/stack"), this.stackAction);
        this.tc = new TrivialConfigurator(rulesMap);
        this.tc.setContext(context);
    }

    @Test
    public void extDirKeyFound() throws JoranException {
        this.tc.doConfigure((InputStream)this.toXml("EXT_DIR"));
        this.assertResultContains(EXT_DIR_VAL);
    }

    @Test
    public void dataDirKeyFound() throws JoranException {
        this.tc.doConfigure((InputStream)this.toXml("DATA_DIR"));
        this.assertResultContains(DATA_DIR_VAL);
    }

    @Test
    public void versionNameKeyFound() throws JoranException {
        this.tc.doConfigure((InputStream)this.toXml("VERSION_NAME"));
        String ver = (String)this.stackAction.getStack().pop();
        Assert.assertEquals((Object)VERSION_NAME_VAL, (Object)ver.substring(0, VERSION_NAME_VAL.length()));
    }

    @Test
    public void versionCodeKeyFound() throws JoranException {
        this.tc.doConfigure((InputStream)this.toXml("VERSION_CODE"));
        this.assertResultContains(VERSION_CODE_VAL);
    }

    @Test
    public void multipleAndroidKeysFound() throws JoranException {
        this.tc.doConfigure((InputStream)this.toXml("EXT_DIR", "PACKAGE_NAME", "DATA_DIR", "VERSION_CODE"));
        this.assertResultContains(EXT_DIR_VAL, PACKAGE_VAL, DATA_DIR_VAL, VERSION_CODE_VAL);
    }

    private void assertResultContains(String ... expected) {
        Stack<String> witness = new Stack<String>();
        witness.addAll(Arrays.asList(expected));
        Assert.assertEquals(witness, (Object)this.stackAction.getStack());
    }

    private ByteArrayInputStream toXml(String ... names) {
        StringBuffer buf = new StringBuffer();
        buf.append("<x>");
        for (String x : names) {
            buf.append("<stack name='${" + x + "}'/>");
        }
        buf.append("</x>");
        return new ByteArrayInputStream(buf.toString().getBytes());
    }
}

