/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.android;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.android.LogcatAppender;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.robolectric.RobolectricTestRunner;
import org.robolectric.shadows.ShadowLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=RobolectricTestRunner.class)
public class LogcatAppenderTest {
    private static final String LOGGER_NAME = "LOGCAT";
    private static final int MAX_TAG_LENGTH = 23;
    private static final String TAG = "123456789012345678901234567890";
    private static final String TRUNCATED_TAG = "123456789012345678901234567890".substring(0, 22) + "*";
    private LogcatAppender logcatAppender;
    private LoggerContext context = new LoggerContext();
    private Logger root = this.context.getLogger("ROOT");

    @Before
    public void before() {
        this.context.reset();
        this.root.detachAndStopAllAppenders();
        this.configureLogcatAppender();
    }

    @Test
    public void longTagAllowedIfNotCheckLoggable() {
        LoggingEvent event = new LoggingEvent();
        event.setMessage(TAG);
        boolean checkLoggable = false;
        this.setTagPattern(TAG, checkLoggable);
        String actualTag = this.logcatAppender.getTag((ILoggingEvent)event);
        Assert.assertThat((Object)TRUNCATED_TAG, (Matcher)Matchers.is((Matcher)Matchers.not((Object)actualTag)));
        Assert.assertThat((Object)TAG, (Matcher)Matchers.is((Object)actualTag));
    }

    @Test
    public void longTagTruncatedIfCheckLoggable() {
        LoggingEvent event = new LoggingEvent();
        event.setMessage(TAG);
        boolean checkLoggable = true;
        this.setTagPattern(TAG, checkLoggable);
        String actualTag = this.logcatAppender.getTag((ILoggingEvent)event);
        Assert.assertThat((Object)TRUNCATED_TAG, (Matcher)Matchers.is((Object)actualTag));
        Assert.assertThat((Object)TAG, (Matcher)Matchers.is((Matcher)Matchers.not((Object)actualTag)));
    }

    @Test
    public void tagExcludesStackTraces() {
        LoggingEvent event = new LoggingEvent();
        Throwable throwable = new Throwable("throwable");
        ThrowableProxy tp = new ThrowableProxy(throwable);
        event.setThrowableProxy(tp);
        event.setMessage(TAG);
        this.setTagPattern(TAG, true);
        String actualTag = this.logcatAppender.getTagEncoder().getLayout().doLayout((Object)event);
        Assert.assertThat((Object)TAG, (Matcher)Matchers.is((Object)actualTag));
    }

    private void setTagPattern(String tag, boolean checkLoggable) {
        this.logcatAppender.stop();
        this.logcatAppender.setCheckLoggable(checkLoggable);
        this.logcatAppender.getTagEncoder().setPattern(tag);
        this.logcatAppender.start();
    }

    private void configureLogcatAppender() {
        this.logcatAppender = new LogcatAppender();
        this.logcatAppender.setContext((Context)this.context);
        this.logcatAppender.setName(LOGGER_NAME);
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        encoder.setContext((Context)this.context);
        encoder.setPattern("%msg");
        encoder.start();
        PatternLayoutEncoder tagEncoder = new PatternLayoutEncoder();
        tagEncoder.setContext((Context)this.context);
        tagEncoder.setPattern(TAG);
        tagEncoder.start();
        this.logcatAppender.setTagEncoder(tagEncoder);
        this.logcatAppender.setEncoder(encoder);
        this.logcatAppender.start();
    }

    private boolean logcatContains(List<ShadowLog.LogItem> logs, int level, String errorMessage) {
        boolean found = false;
        for (ShadowLog.LogItem s : logs) {
            if (level != s.type || !s.msg.contains(errorMessage)) continue;
            found = true;
            break;
        }
        return found;
    }

    private void assertLogcatContains(int level, String errorMessage) {
        List logs = ShadowLog.getLogsForTag((String)LOGGER_NAME);
        Assert.assertThat((Object)logs, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)this.logcatContains(logs, level, errorMessage), (Matcher)Matchers.is((Object)true));
    }

    private void addLogcatAppenderToRoot() {
        PatternLayoutEncoder encoder2 = new PatternLayoutEncoder();
        encoder2.setContext((Context)this.context);
        encoder2.setPattern("[%thread] %method\\(\\): %msg%n");
        encoder2.start();
        LogcatAppender logcatAppender = new LogcatAppender();
        logcatAppender.setContext((Context)this.context);
        logcatAppender.setName(LOGGER_NAME);
        logcatAppender.setEncoder(encoder2);
        logcatAppender.start();
        this.root.addAppender((Appender)logcatAppender);
    }

    @Test
    public void logsExceptionWhenMessageTrailsWithNewline() {
        this.addLogcatAppenderToRoot();
        ShadowLog.reset();
        this.context.getLogger(LOGGER_NAME).debug("msg\n", (Throwable)new NullPointerException());
        this.assertLogcatContains(3, NullPointerException.class.getName());
    }

    @Test
    public void logsExceptionWhenMessageHasNoTrailingNewline() {
        this.addLogcatAppenderToRoot();
        ShadowLog.reset();
        this.context.getLogger(LOGGER_NAME).debug("msg", (Throwable)new NullPointerException());
        this.assertLogcatContains(3, NullPointerException.class.getName());
    }
}

