/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.android;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.android.SQLiteAppender;
import ch.qos.logback.classic.android.SQLiteLogCleaner;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.status.StatusUtil;
import ch.qos.logback.core.util.Duration;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.robolectric.RobolectricTestRunner;

@RunWith(value=RobolectricTestRunner.class)
public class SQLiteAppenderTest {
    private static final String TEST_SQLITE_FILENAME = "build/test-output/SQLiteAppenderTest/logback.db";
    private static final long EXPIRY_MS = 500L;
    private static final long NO_EXPIRY = 0L;
    private static final String SQLITE_APPENDER_WITHOUT_MAX_HISTORY_XML = "<configuration><appender name='db' class='ch.qos.logback.classic.android.SQLiteAppender'><filename>build/test-output/SQLiteAppenderTest/logback.db</filename></appender><root level='DEBUG'><appender-ref ref='db' /></root></configuration>";
    private static final String SQLITE_APPENDER_WITH_MAX_HISTORY_XML = "<configuration><appender name='db' class='ch.qos.logback.classic.android.SQLiteAppender'><filename>build/test-output/SQLiteAppenderTest/logback.db</filename><maxHistory>500 milli</maxHistory></appender><root level='DEBUG'><appender-ref ref='db' /></root></configuration>";
    @Rule
    public TemporaryFolder tmp = new TemporaryFolder();
    private SQLiteLogCleaner logCleaner;
    private long startTimeMs;
    private LoggerContext context;
    private SQLiteAppender appender;

    @Before
    public void setup() throws Exception {
        this.context = new LoggerContext();
        this.context.putProperty("PACKAGE_NAME", "com.example");
        this.appender = new SQLiteAppender();
        this.appender.setFilename(TEST_SQLITE_FILENAME);
        this.appender.setContext((Context)this.context);
        this.logCleaner = (SQLiteLogCleaner)Mockito.mock(SQLiteLogCleaner.class);
    }

    @After
    public void teardown() {
        new File(TEST_SQLITE_FILENAME).delete();
    }

    @Test
    public void maxHistoryRemovesExpiredLogs() throws InterruptedException, JoranException {
        this.configureLogbackByString(SQLITE_APPENDER_WITH_MAX_HISTORY_XML);
        int count = 12;
        this.addLogEvents(12, 250L);
        Cursor c = this.getCursor();
        this.assertRowCount(c, 0, 12);
        int colIndex = c.getColumnIndex("timestmp");
        while (c.moveToNext()) {
            long timestamp = c.getLong(colIndex);
            Assert.assertThat((Object)timestamp, (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Long.valueOf(this.startTimeMs - 500L))));
        }
    }

    @Test
    public void maxHistoryIsDisabledByDefault() throws InterruptedException, JoranException {
        this.configureLogbackByString(SQLITE_APPENDER_WITHOUT_MAX_HISTORY_XML);
        int count = 1000;
        this.addLogEvents(1000, 0L);
        Assert.assertThat((Object)this.getCursor().getCount(), (Matcher)Matchers.is((Object)1000));
    }

    @Test
    public void cleanuOccursAtAppenderStartup() throws InterruptedException {
        this.addAppenderToContext("1 hour");
        ((SQLiteLogCleaner)Mockito.verify((Object)this.logCleaner, (VerificationMode)Mockito.times((int)1))).performLogCleanup((SQLiteDatabase)org.mockito.Matchers.any(SQLiteDatabase.class), (Duration)org.mockito.Matchers.any(Duration.class));
    }

    @Test
    public void cleanupDoesNotOccurBeforeExpiration() throws InterruptedException {
        this.addAppenderToContext("1 hour");
        this.addLogEvents(3, 0L);
        ((SQLiteLogCleaner)Mockito.verify((Object)this.logCleaner, (VerificationMode)Mockito.times((int)1))).performLogCleanup((SQLiteDatabase)org.mockito.Matchers.any(SQLiteDatabase.class), (Duration)org.mockito.Matchers.any(Duration.class));
    }

    @Test
    public void cleanupOccursAfterEveryExpiration() throws InterruptedException {
        this.addAppenderToContext("500 milli");
        int count = 7;
        long delayMs = 250L;
        int expectedCallCount = (int)Math.ceil(3.5);
        this.addLogEvents(7, 250L);
        ((SQLiteLogCleaner)Mockito.verify((Object)this.logCleaner, (VerificationMode)Mockito.times((int)expectedCallCount))).performLogCleanup((SQLiteDatabase)org.mockito.Matchers.any(SQLiteDatabase.class), (Duration)org.mockito.Matchers.any(Duration.class));
    }

    @Test
    public void dirAsFilenameResultsInDefault() throws IOException {
        File file = this.appender.getDatabaseFile(this.tmp.newFolder().getAbsolutePath());
        Assert.assertThat((Object)file, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)file.getName(), (Matcher)Matchers.is((Object)"logback.db"));
    }

    @Test
    public void nullFilenameResultsInDefault() throws IOException {
        File file = this.appender.getDatabaseFile(null);
        Assert.assertThat((Object)file, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)file.getName(), (Matcher)Matchers.is((Object)"logback.db"));
    }

    @Test
    public void emptyFilenameResultsInDefault() throws IOException {
        File file = this.appender.getDatabaseFile("");
        Assert.assertThat((Object)file, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)file.getName(), (Matcher)Matchers.is((Object)"logback.db"));
    }

    @Test
    public void blankFilenameResultsInDefault() throws IOException {
        File file = this.appender.getDatabaseFile("  ");
        Assert.assertThat((Object)file, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)file.getName(), (Matcher)Matchers.is((Object)"logback.db"));
    }

    @Test
    public void setsDatabaseFilename() throws IOException {
        File tmpFile = this.tmp.newFile();
        File file = this.appender.getDatabaseFile(tmpFile.getAbsolutePath());
        Assert.assertThat((Object)file, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)file.getName(), (Matcher)Matchers.is((Object)tmpFile.getName()));
    }

    @Test
    public void getMaxHistoryReturnsOriginalSetting() {
        this.appender.setMaxHistory("800 milli");
        Assert.assertThat((Object)this.appender.getMaxHistory(), (Matcher)Matchers.containsString((String)"800 milli"));
        this.appender.setMaxHistory("500 seconds");
        Assert.assertThat((Object)this.appender.getMaxHistory(), (Matcher)Matchers.containsString((String)"8 minutes"));
        this.appender.setMaxHistory("120 minutes");
        Assert.assertThat((Object)this.appender.getMaxHistory(), (Matcher)Matchers.containsString((String)"2 hours"));
        this.appender.setMaxHistory("1 hour");
        Assert.assertThat((Object)this.appender.getMaxHistory(), (Matcher)Matchers.containsString((String)"1 hour"));
        this.appender.setMaxHistory("7 days");
        Assert.assertThat((Object)this.appender.getMaxHistory(), (Matcher)Matchers.containsString((String)"168 hours"));
    }

    @Test
    public void maxHistorySetsMilliseconds() {
        this.appender.setMaxHistory("800 milli");
        Assert.assertThat((Object)this.appender.getMaxHistoryMs(), (Matcher)Matchers.is((Object)800L));
        this.appender.setMaxHistory("500 seconds");
        Assert.assertThat((Object)this.appender.getMaxHistoryMs(), (Matcher)Matchers.is((Object)500000L));
        this.appender.setMaxHistory("120 minutes");
        Assert.assertThat((Object)this.appender.getMaxHistoryMs(), (Matcher)Matchers.is((Object)0x6DDD00L));
        this.appender.setMaxHistory("1 hour");
        Assert.assertThat((Object)this.appender.getMaxHistoryMs(), (Matcher)Matchers.is((Object)3600000L));
        this.appender.setMaxHistory("7 days");
        Assert.assertThat((Object)this.appender.getMaxHistoryMs(), (Matcher)Matchers.is((Object)604800000L));
    }

    @Test
    public void getMaxHistoryEmptyByDefault() {
        Assert.assertThat((Object)this.appender.getMaxHistory(), (Matcher)Matchers.is((Object)""));
    }

    @Test
    public void getMaxHistoryMsZeroByDefault() {
        Assert.assertThat((Object)this.appender.getMaxHistoryMs(), (Matcher)Matchers.is((Object)0L));
    }

    private void configureLogbackByString(String xml) throws JoranException {
        JoranConfigurator config = new JoranConfigurator();
        config.setContext((Context)this.context);
        ByteArrayInputStream stream = new ByteArrayInputStream(xml.getBytes());
        config.doConfigure((InputStream)stream);
        StatusUtil statusUtil = new StatusUtil((Context)this.context);
        if (statusUtil.getHighestLevel(0L) == 2) {
            Assert.fail((String)"Configuration error found");
        }
    }

    private void addLogEvents(int count, long delayMs) throws InterruptedException {
        Logger log = this.context.getLogger(SQLiteAppenderTest.class);
        this.startTimeMs = System.currentTimeMillis();
        for (int i = 0; i < count; ++i) {
            log.info("i={}", (Object)i);
            if (delayMs <= 0L) continue;
            Thread.sleep(delayMs);
        }
    }

    private void addAppenderToContext(String maxHistory) {
        this.appender.setMaxHistory(maxHistory);
        this.appender.setLogCleaner(this.logCleaner);
        this.appender.start();
        Logger testRoot = this.context.getLogger(SQLiteAppenderTest.class);
        testRoot.addAppender((Appender)this.appender);
    }

    private Cursor getCursor() {
        SQLiteDatabase db = SQLiteDatabase.openDatabase((String)TEST_SQLITE_FILENAME, null, (int)1);
        return db.rawQuery("SELECT timestmp FROM logging_event;", null);
    }

    private void assertRowCount(Cursor c, int min, int max) {
        Assert.assertThat((Object)c.getCount(), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(min))));
        Assert.assertThat((Object)c.getCount(), (Matcher)Matchers.is((Matcher)Matchers.lessThan((Comparable)Integer.valueOf(max))));
    }
}

