/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.control;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.control.CreateLogger;
import ch.qos.logback.classic.control.Scenario;
import ch.qos.logback.classic.control.ScenarioRandomUtil;
import ch.qos.logback.classic.control.SetLevel;
import java.util.LinkedList;

public class ScenarioMaker {
    private static final int AVERAGE_LOGGER_DEPTH = 4;
    private static final int LOGGER_DEPT_DEV = 2;
    private static final int CREATE_LOGGER_TO_SET_LEVEL_FREQUENCY = 5;
    private static final int SECOND_SET_LEVEL_FREQUENCY = 3;
    private static long count = 0L;

    public static Scenario makeTypeAScenario(int len) {
        Scenario scenario = new Scenario();
        for (int i = 0; i < len; ++i) {
            String loggerName = ScenarioRandomUtil.randomLoggerName(4, 2);
            scenario.add(new CreateLogger(loggerName));
        }
        return scenario;
    }

    public static Scenario makeRealisticCreationScenario(int len) {
        Scenario scenario = new Scenario();
        LinkedList<String> queue = new LinkedList<String>();
        int loggerCreationCount = 0;
        queue.add("");
        while (loggerCreationCount < len) {
            String loggerName;
            int randomChildrenCount;
            if (count % 100L == 0L) {
                System.out.println("count=" + count);
            }
            if ((randomChildrenCount = ScenarioRandomUtil.randomChildrenCount(loggerName = (String)queue.removeFirst())) == 0) {
                scenario.add(new CreateLogger(loggerName));
                ScenarioMaker.addSetLevelSubScenario(scenario, loggerName);
                ++loggerCreationCount;
                continue;
            }
            for (int i = 0; i < randomChildrenCount; ++i) {
                String childName;
                if (loggerName.equals("")) {
                    childName = ScenarioRandomUtil.randomId();
                    count += (long)childName.length();
                } else {
                    childName = loggerName + '.' + ScenarioRandomUtil.randomId();
                    count += (long)childName.length();
                }
                queue.add(childName);
                ScenarioMaker.addSetLevelSubScenario(scenario, loggerName);
                ++loggerCreationCount;
            }
        }
        return scenario;
    }

    static void addSetLevelSubScenario(Scenario scenario, String loggerName) {
        if (ScenarioRandomUtil.oneInFreq(5)) {
            Level l = ScenarioRandomUtil.randomLevel();
            scenario.add(new SetLevel(l, loggerName));
            if (ScenarioRandomUtil.oneInFreq(3)) {
                l = ScenarioRandomUtil.randomLevel();
                scenario.add(new SetLevel(l, loggerName));
            }
        }
    }
}

