/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.joran.action;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.Status;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseIncludesTezt {
    protected static final String OUT_DIR = "build/test-output/";
    protected static final String RESOURCE_DIR = "src/test/resources/";
    protected LoggerContext context;
    protected JoranConfigurator config;
    private String pathToConfig;

    protected BaseIncludesTezt(String path) {
        this.pathToConfig = path;
    }

    @Before
    public void setup() throws JoranException {
        this.config = new JoranConfigurator();
        this.context = new LoggerContext();
        this.context.putProperty("OUT_DIR", OUT_DIR);
        this.config.setContext((Context)this.context);
        this.config.doConfigure(this.pathToConfig);
    }

    @Test
    public void parentParsesChildConfig() throws JoranException {
        this.assertNoErrors(this.config);
    }

    @Test
    public void parentParsesAllChildAppenders() {
        int childAppenderCount = 2;
        boolean parentAppenderCount = true;
        this.assertAppenderCount(3);
    }

    protected void assertAppenderCount(int count) {
        Map objectMap = this.config.getInterpretationContext().getObjectMap();
        Map appenderMap = (Map)objectMap.get("APPENDER_BAG");
        Assert.assertThat((Object)appenderMap.size(), (Matcher)Is.is((Object)count));
    }

    protected void assertHasAppender(String name, Class<?> clazz) {
        Map objectMap = this.config.getInterpretationContext().getObjectMap();
        Map appenderMap = (Map)objectMap.get("APPENDER_BAG");
        Object appender = appenderMap.get(name);
        Assert.assertThat(appender, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(clazz)));
    }

    protected void assertNoErrors(JoranConfigurator config) {
        List status = config.getStatusManager().getCopyOfStatusList();
        for (Status s : status) {
            Assert.assertThat((Object)s, (Matcher)Is.is((Matcher)IsNot.not((Matcher)IsInstanceOf.instanceOf(ErrorStatus.class))));
        }
    }
}

