/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.joran.action;

import ch.qos.logback.classic.joran.action.ConditionalIncludeAction;
import ch.qos.logback.classic.joran.action.FindIncludeAction;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.joran.TrivialConfigurator;
import ch.qos.logback.core.joran.action.IncludeAction;
import ch.qos.logback.core.joran.action.NOPAction;
import ch.qos.logback.core.joran.action.ext.StackAction;
import ch.qos.logback.core.joran.spi.ElementSelector;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.status.StatusChecker;
import ch.qos.logback.core.testUtil.FileTestUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Stack;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.xml.sax.SAXParseException;

public class ConditionalIncludeActionTest {
    Context context = new ContextBase();
    StatusChecker statusChecker = new StatusChecker(this.context);
    TrivialConfigurator tc;
    StackAction stackAction;
    private static final String INCLUSION_DIR_PREFIX = "src/test/input/joran/inclusion/";
    private static final String SECOND_FILE = "src/test/input/joran/inclusion/second.xml";
    private static final String INCLUDED_FILE = "src/test/input/joran/inclusion/included.xml";
    private static final String URL_TO_INCLUDE = "file:./src/test/input/joran/inclusion/included.xml";
    private static final String INVALID = "src/test/input/joran/inclusion/invalid.xml";
    private static final String INCLUDED_AS_RESOURCE = "asResource/joran/inclusion/includedAsResource.xml";
    private static final String ANDROID_XML_RESOURCE = "asResource/AndroidManifest.xml";

    @Before
    public void setUp() throws Exception {
        FileTestUtil.makeTestOutputDir();
        HashMap<ElementSelector, Object> rulesMap = new HashMap<ElementSelector, Object>();
        rulesMap.put(new ElementSelector("x"), new NOPAction());
        rulesMap.put(new ElementSelector("x/include"), new IncludeAction());
        rulesMap.put(new ElementSelector("x/findInclude"), new FindIncludeAction());
        rulesMap.put(new ElementSelector("x/findInclude/include"), new ConditionalIncludeAction());
        this.stackAction = new StackAction();
        rulesMap.put(new ElementSelector("x/stack"), this.stackAction);
        this.tc = new TrivialConfigurator(rulesMap);
        this.tc.setContext(this.context);
    }

    @Test
    public void findsIncludeWithRegularInclude() throws JoranException {
        String xml = "<x><findInclude><include file='src/test/input/joran/inclusion/second.xml'/><include file='nonexistent.txt'/></findInclude><stack name='A'/><stack name='B'/><include file='src/test/input/joran/inclusion/second.xml'/><stack name='C'/></x>";
        ByteArrayInputStream stream = new ByteArrayInputStream("<x><findInclude><include file='src/test/input/joran/inclusion/second.xml'/><include file='nonexistent.txt'/></findInclude><stack name='A'/><stack name='B'/><include file='src/test/input/joran/inclusion/second.xml'/><stack name='C'/></x>".getBytes());
        this.tc.doConfigure((InputStream)stream);
        this.verifyConfig("SECOND", "A", "B", "SECOND", "C");
    }

    @Test
    public void findsIncludeFromBeginningOfPathList() throws JoranException {
        String xml = "<x><findInclude><include file='src/test/input/joran/inclusion/second.xml'/><include file='nonexistent.txt'/><include file='src/test/input/joran/inclusion/invalid.xml'/></findInclude><stack name='C'/></x>";
        ByteArrayInputStream stream = new ByteArrayInputStream("<x><findInclude><include file='src/test/input/joran/inclusion/second.xml'/><include file='nonexistent.txt'/><include file='src/test/input/joran/inclusion/invalid.xml'/></findInclude><stack name='C'/></x>".getBytes());
        this.tc.doConfigure((InputStream)stream);
        this.verifyConfig("SECOND", "C");
    }

    @Test
    public void findsIncludeFromMiddleOfPathList() throws JoranException {
        String xml = "<x><findInclude><include file='nonexistent.txt'/><include file='src/test/input/joran/inclusion/second.xml'/><include file='nonexistent.txt'/></findInclude><stack name='C'/></x>";
        ByteArrayInputStream stream = new ByteArrayInputStream("<x><findInclude><include file='nonexistent.txt'/><include file='src/test/input/joran/inclusion/second.xml'/><include file='nonexistent.txt'/></findInclude><stack name='C'/></x>".getBytes());
        this.tc.doConfigure((InputStream)stream);
        this.verifyConfig("SECOND", "C");
    }

    @Test
    public void findsIncludeFromEndOfPathList() throws JoranException {
        String xml = "<x><findInclude><include file='nonexistent.txt'/><include file='nonexistent.txt'/><include file='src/test/input/joran/inclusion/second.xml'/></findInclude><stack name='C'/></x>";
        ByteArrayInputStream stream = new ByteArrayInputStream("<x><findInclude><include file='nonexistent.txt'/><include file='nonexistent.txt'/><include file='src/test/input/joran/inclusion/second.xml'/></findInclude><stack name='C'/></x>".getBytes());
        this.tc.doConfigure((InputStream)stream);
        this.verifyConfig("SECOND", "C");
    }

    @Test
    public void errorsOutForInvalidXmlAtFoundPath() throws JoranException {
        String xml = "<x><findInclude><include file='src/test/input/joran/inclusion/invalid.xml'/><include file='nonexistent.txt'/><include file='src/test/input/joran/inclusion/second.xml'/></findInclude><stack name='C'/></x>";
        ByteArrayInputStream stream = new ByteArrayInputStream("<x><findInclude><include file='src/test/input/joran/inclusion/invalid.xml'/><include file='nonexistent.txt'/><include file='src/test/input/joran/inclusion/second.xml'/></findInclude><stack name='C'/></x>".getBytes());
        this.tc.doConfigure((InputStream)stream);
        Assert.assertEquals((long)2L, (long)this.statusChecker.getHighestLevel(0L));
        Assert.assertTrue((boolean)this.statusChecker.containsException(SAXParseException.class));
        this.verifyConfig("C");
    }

    @Test
    public void configHandlesMultipleFindIncludeElements() throws JoranException {
        String xml = "<x><findInclude><include file='nonexistent.txt'/><include file='src/test/input/joran/inclusion/second.xml'/></findInclude><findInclude><include file='nonexistent.txt'/><include file='src/test/input/joran/inclusion/second.xml'/></findInclude><stack name='B'/><findInclude><include file='nonexistent.txt'/><include file='src/test/input/joran/inclusion/second.xml'/></findInclude><stack name='C'/></x>";
        ByteArrayInputStream stream = new ByteArrayInputStream("<x><findInclude><include file='nonexistent.txt'/><include file='src/test/input/joran/inclusion/second.xml'/></findInclude><findInclude><include file='nonexistent.txt'/><include file='src/test/input/joran/inclusion/second.xml'/></findInclude><stack name='B'/><findInclude><include file='nonexistent.txt'/><include file='src/test/input/joran/inclusion/second.xml'/></findInclude><stack name='C'/></x>".getBytes());
        this.tc.doConfigure((InputStream)stream);
        this.verifyConfig("SECOND", "SECOND", "B", "SECOND", "C");
    }

    @Test
    public void findsIncludeFromSinglePath() throws JoranException {
        String xml = "<x><findInclude><include file='src/test/input/joran/inclusion/second.xml'/></findInclude><stack name='C'/></x>";
        ByteArrayInputStream stream = new ByteArrayInputStream("<x><findInclude><include file='src/test/input/joran/inclusion/second.xml'/></findInclude><stack name='C'/></x>".getBytes());
        this.tc.doConfigure((InputStream)stream);
        this.verifyConfig("SECOND", "C");
    }

    @Test
    public void findsIncludeFromManyPaths() throws JoranException {
        String NONEXIST_INCLUDES = new String(new char[1000]).replace("\u0000", "<include file='nonexistent.txt'/>");
        String xml = "<x><findInclude>" + NONEXIST_INCLUDES + "<include file='" + SECOND_FILE + "'/>" + NONEXIST_INCLUDES + "</findInclude>" + "<stack name='C'/>" + "</x>";
        ByteArrayInputStream stream = new ByteArrayInputStream(xml.getBytes());
        this.tc.doConfigure((InputStream)stream);
        this.verifyConfig("SECOND", "C");
    }

    @Test
    public void findsIncludeFromFewPaths() throws JoranException {
        String NONEXIST_INCLUDES = new String(new char[5]).replace("\u0000", "<include file='nonexistent.txt'/>");
        String xml = "<x><findInclude>" + NONEXIST_INCLUDES + "<include file='" + SECOND_FILE + "'/>" + NONEXIST_INCLUDES + "</findInclude>" + "<stack name='C'/>" + "</x>";
        ByteArrayInputStream stream = new ByteArrayInputStream(xml.getBytes());
        this.tc.doConfigure((InputStream)stream);
        this.verifyConfig("SECOND", "C");
    }

    @Test
    public void includesResource() throws JoranException {
        String xml = "<x><findInclude><include resource='asResource/joran/inclusion/includedAsResource.xml'/></findInclude><stack name='C'/></x>";
        ByteArrayInputStream stream = new ByteArrayInputStream("<x><findInclude><include resource='asResource/joran/inclusion/includedAsResource.xml'/></findInclude><stack name='C'/></x>".getBytes());
        this.tc.doConfigure((InputStream)stream);
        this.verifyConfig("AR_A", "AR_B", "C");
    }

    @Test
    public void ignoresNonexistentResource() throws JoranException {
        String xml = "<x><findInclude><include resource='nonexistent.txt'/><include resource='asResource/joran/inclusion/includedAsResource.xml'/></findInclude><stack name='C'/></x>";
        ByteArrayInputStream stream = new ByteArrayInputStream("<x><findInclude><include resource='nonexistent.txt'/><include resource='asResource/joran/inclusion/includedAsResource.xml'/></findInclude><stack name='C'/></x>".getBytes());
        this.tc.doConfigure((InputStream)stream);
        this.verifyConfig("AR_A", "AR_B", "C");
    }

    @Test
    public void includesUrl() throws JoranException {
        String xml = "<x><findInclude><include url='file:./src/test/input/joran/inclusion/included.xml'/></findInclude><stack name='C'/></x>";
        ByteArrayInputStream stream = new ByteArrayInputStream("<x><findInclude><include url='file:./src/test/input/joran/inclusion/included.xml'/></findInclude><stack name='C'/></x>".getBytes());
        this.tc.doConfigure((InputStream)stream);
        this.verifyConfig("IA", "IB", "C");
    }

    @Test
    public void ignoresUnknownUrl() throws JoranException {
        String xml = "<x><findInclude><include url='http://nonexistent.html'/><include url='file:./src/test/input/joran/inclusion/included.xml'/></findInclude><stack name='C'/></x>";
        ByteArrayInputStream stream = new ByteArrayInputStream("<x><findInclude><include url='http://nonexistent.html'/><include url='file:./src/test/input/joran/inclusion/included.xml'/></findInclude><stack name='C'/></x>".getBytes());
        this.tc.doConfigure((InputStream)stream);
        this.verifyConfig("IA", "IB", "C");
    }

    @Test
    public void ignoresMalformedUrl() throws JoranException {
        String xml = "<x><findInclude><include url='htp://nonexistent.html'/><include url='file:./src/test/input/joran/inclusion/included.xml'/></findInclude><stack name='C'/></x>";
        ByteArrayInputStream stream = new ByteArrayInputStream("<x><findInclude><include url='htp://nonexistent.html'/><include url='file:./src/test/input/joran/inclusion/included.xml'/></findInclude><stack name='C'/></x>".getBytes());
        this.tc.doConfigure((InputStream)stream);
        this.verifyConfig("IA", "IB", "C");
    }

    @Test
    public void includesAndroidManifest() throws JoranException {
        String xml = "<x><findInclude><include resource='nonexistent.txt'/><include resource='asResource/AndroidManifest.xml'/></findInclude><stack name='C'/></x>";
        ByteArrayInputStream stream = new ByteArrayInputStream("<x><findInclude><include resource='nonexistent.txt'/><include resource='asResource/AndroidManifest.xml'/></findInclude><stack name='C'/></x>".getBytes());
        this.tc.doConfigure((InputStream)stream);
    }

    void verifyConfig(String ... expected) {
        Stack<String> witness = new Stack<String>();
        witness.addAll(Arrays.asList(expected));
        Assert.assertEquals(witness, (Object)this.stackAction.getStack());
    }
}

