/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.multiJVM;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.multiJVM.LoggingThread;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.util.StatusPrinter;

public class SafeModeRollingFileAppender {
    static long LEN;
    static String FILENAME;
    static String STAMP;
    static final String DATE_PATTERN = "yyyy-MM-dd_HH_mm_ss";

    public static void main(String[] argv) throws Exception {
        if (argv.length != 3) {
            SafeModeRollingFileAppender.usage("Wrong number of arguments.");
        }
        STAMP = argv[0];
        LEN = Integer.parseInt(argv[1]);
        FILENAME = argv[2];
        SafeModeRollingFileAppender.writeContinously(STAMP, FILENAME, true);
    }

    static void usage(String msg) {
        System.err.println(msg);
        System.err.println("Usage: java " + SafeModeRollingFileAppender.class.getName() + " stamp runLength filename\n" + " stamp JVM instance stamp\n" + "   runLength (integer) the number of logs to generate perthread" + "    filename (string) the filename where to write\n");
        System.exit(1);
    }

    static LoggerContext buildLoggerContext(String stamp, String filename, boolean safetyMode) {
        LoggerContext loggerContext = new LoggerContext();
        RollingFileAppender rfa = new RollingFileAppender();
        PatternLayoutEncoder patternLayout = new PatternLayoutEncoder();
        patternLayout.setPattern(stamp + " %5p - %-50m%n");
        patternLayout.setContext((Context)loggerContext);
        patternLayout.start();
        rfa.setEncoder((Encoder)patternLayout);
        rfa.setAppend(true);
        rfa.setPrudent(safetyMode);
        rfa.setContext((Context)loggerContext);
        TimeBasedRollingPolicy tbrp = new TimeBasedRollingPolicy();
        tbrp.setContext((Context)loggerContext);
        tbrp.setFileNamePattern(filename + "-%d{" + DATE_PATTERN + "}.log");
        tbrp.setParent((FileAppender)rfa);
        tbrp.start();
        rfa.setRollingPolicy((RollingPolicy)tbrp);
        rfa.start();
        Logger root = loggerContext.getLogger("ROOT");
        root.addAppender((Appender)rfa);
        return loggerContext;
    }

    static void writeContinously(String stamp, String filename, boolean safetyMode) throws Exception {
        LoggerContext lc = SafeModeRollingFileAppender.buildLoggerContext(stamp, filename, safetyMode);
        Logger logger = lc.getLogger(SafeModeRollingFileAppender.class);
        long before = System.nanoTime();
        int i = 0;
        while ((long)i < LEN) {
            logger.debug(LoggingThread.msgLong + " " + i);
            ++i;
        }
        lc.stop();
        StatusPrinter.print((Context)lc);
        double durationPerLog = (double)(System.nanoTime() - before) / ((double)LEN * 1000.0);
        System.out.println("Average duration of " + durationPerLog + " microseconds per log. Safety mode " + safetyMode);
        System.out.println("------------------------------------------------");
    }
}

