/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.net;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.net.SyslogAppender;
import ch.qos.logback.classic.net.mock.MockSyslogServer;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.testUtil.RandomUtil;
import ch.qos.logback.core.util.StatusPrinter;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class SyslogAppenderTest {
    LoggerContext lc = new LoggerContext();
    SyslogAppenderFriend sa;
    MockSyslogServer mockServer;
    String loggerName = this.getClass().getName();
    Logger logger = this.lc.getLogger(this.loggerName);

    @Before
    public void setUp() throws Exception {
        this.lc.setName("test");
        this.sa = new SyslogAppenderFriend();
        this.sa.setContext((Context)this.lc);
    }

    @After
    public void tearDown() throws Exception {
    }

    public void setMockServerAndConfigure(int expectedCount) throws InterruptedException {
        this.setMockServerAndConfigure(expectedCount, true);
    }

    public void setMockServerAndConfigure(int expectedCount, boolean start) throws InterruptedException {
        int port = RandomUtil.getRandomServerPort();
        this.mockServer = new MockSyslogServer(expectedCount, port);
        this.mockServer.start();
        Thread.sleep(100L);
        this.sa.setSyslogHost("localhost");
        this.sa.setFacility("MAIL");
        this.sa.setPort(port);
        this.sa.setSuffixPattern("[%thread] %logger %msg");
        this.sa.setStackTracePattern("[%thread] foo \t");
        if (start) {
            this.sa.start();
            Assert.assertTrue((boolean)this.sa.isStarted());
        }
        String loggerName = this.getClass().getName();
        Logger logger = this.lc.getLogger(loggerName);
        logger.addAppender((Appender)this.sa);
    }

    @Test
    public void basic() throws InterruptedException {
        this.setMockServerAndConfigure(1);
        String logMsg = "hello";
        this.logger.debug(logMsg);
        this.mockServer.join(8000L);
        Assert.assertTrue((boolean)this.mockServer.isFinished());
        Assert.assertEquals((int)1, (int)this.mockServer.getMessageList().size());
        String msg = this.mockServer.getMessageList().get(0);
        String threadName = Thread.currentThread().getName();
        String expected = "<23>";
        Assert.assertTrue((boolean)msg.startsWith(expected));
        String first = "<\\d{2}>\\w{3} \\d{2} \\d{2}(:\\d{2}){2} [\\w.-]* ";
        this.checkRegexMatch(msg, first + "\\[" + threadName + "\\] " + this.loggerName + " " + logMsg);
    }

    @Test
    public void tException() throws InterruptedException {
        this.setMockServerAndConfigure(21);
        String logMsg = "hello";
        String exMsg = "just testing";
        Exception ex = new Exception(exMsg);
        this.logger.debug(logMsg, (Throwable)ex);
        StatusPrinter.print((Context)this.lc);
        this.mockServer.join(8000L);
        Assert.assertTrue((boolean)this.mockServer.isFinished());
        Assert.assertEquals((int)21, (int)this.mockServer.getMessageList().size());
        String msg = this.mockServer.getMessageList().get(0);
        String expected = "<23>";
        Assert.assertTrue((boolean)msg.startsWith(expected));
        String expectedPrefix = "<\\d{2}>\\w{3} \\d{2} \\d{2}(:\\d{2}){2} [\\w.-]* ";
        String threadName = Thread.currentThread().getName();
        String regex = expectedPrefix + "\\[" + threadName + "\\] " + this.loggerName + " " + logMsg;
        this.checkRegexMatch(msg, regex);
        msg = this.mockServer.getMessageList().get(1);
        Assert.assertTrue((boolean)msg.contains(ex.getClass().getName()));
        Assert.assertTrue((boolean)msg.contains(ex.getMessage()));
        msg = this.mockServer.getMessageList().get(2);
        Assert.assertTrue((boolean)msg.startsWith(expected));
        regex = expectedPrefix + "\\[" + threadName + "\\] " + "foo " + '\t' + "at ch\\.qos.*";
        this.checkRegexMatch(msg, regex);
    }

    private void checkRegexMatch(String s, String regex) {
        Assert.assertTrue((String)("The string [" + s + "] did not match regex [" + regex + "]"), (boolean)s.matches(regex));
    }

    @Test
    public void large() throws Exception {
        this.setMockServerAndConfigure(2);
        StringBuilder largeBuf = new StringBuilder();
        for (int i = 0; i < 0x200000; ++i) {
            largeBuf.append('a');
        }
        this.logger.debug(largeBuf.toString());
        String logMsg = "hello";
        this.logger.debug(logMsg);
        Thread.sleep(30L);
        this.logger.debug(logMsg);
        this.mockServer.join(8000L);
        Assert.assertTrue((boolean)this.mockServer.isFinished());
        Assert.assertEquals((int)2, (int)this.mockServer.getMessageList().size());
        String expected = "<23>";
        String expectedPrefix = "<\\d{2}>\\w{3} \\d{2} \\d{2}(:\\d{2}){2} [\\w.-]* ";
        String threadName = Thread.currentThread().getName();
        int maxMessageSize = this.sa.getMaxMessageSize();
        String largeMsg = this.mockServer.getMessageList().get(0);
        Assert.assertTrue((boolean)largeMsg.startsWith(expected));
        String largeRegex = expectedPrefix + "\\[" + threadName + "\\] " + this.loggerName + " " + "a{" + (maxMessageSize - 2000) + "," + maxMessageSize + "}";
        this.checkRegexMatch(largeMsg, largeRegex);
        String msg = this.mockServer.getMessageList().get(1);
        Assert.assertTrue((boolean)msg.startsWith(expected));
        String regex = expectedPrefix + "\\[" + threadName + "\\] " + this.loggerName + " " + logMsg;
        this.checkRegexMatch(msg, regex);
    }

    @Test
    public void LBCLASSIC_50() throws JoranException {
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        JoranConfigurator configurator = new JoranConfigurator();
        configurator.setContext((Context)lc);
        lc.reset();
        configurator.doConfigure("src/test/input/joran/syslog_LBCLASSIC_50.xml");
        org.slf4j.Logger logger = LoggerFactory.getLogger(this.getClass());
        logger.info("hello");
    }

    @Test
    public void unlazyAppenderIsConnectedAtStart() throws InterruptedException {
        this.setMockServerAndConfigure(1, false);
        this.sa.setLazy(false);
        Assert.assertFalse((boolean)this.sa.isInitialized());
        this.sa.start();
        Assert.assertTrue((boolean)this.sa.isInitialized());
    }

    @Test
    public void lazyAppenderIsNotConnectedAtStart() throws InterruptedException {
        this.setMockServerAndConfigure(1, false);
        this.sa.setLazy(true);
        Assert.assertFalse((boolean)this.sa.isInitialized());
        this.sa.start();
        Assert.assertFalse((boolean)this.sa.isInitialized());
    }

    @Test
    public void lazyAppenderIsConnectedOnAppend() throws InterruptedException {
        this.setMockServerAndConfigure(1, false);
        this.sa.setLazy(true);
        Assert.assertFalse((boolean)this.sa.isInitialized());
        this.sa.start();
        Assert.assertFalse((boolean)this.sa.isInitialized());
        this.logger.debug("hello world");
        this.mockServer.join(8000L);
        Assert.assertTrue((boolean)this.sa.isInitialized());
    }

    @Test
    public void lazyAppenderMessageIsDelivered() throws InterruptedException {
        this.setMockServerAndConfigure(1, false);
        this.sa.setLazy(true);
        this.sa.start();
        Marker marker = MarkerFactory.getMarker((String)"testMarker");
        Assert.assertFalse((boolean)this.sa.isInitialized());
        Assert.assertTrue((boolean)this.mockServer.getMessageList().isEmpty());
        this.logger.debug(marker, "test msg");
        Assert.assertTrue((boolean)this.sa.isInitialized());
        this.mockServer.join(8000L);
        Assert.assertTrue((boolean)this.mockServer.isFinished());
        Assert.assertEquals((int)1, (int)this.mockServer.getMessageList().size());
    }

    class SyslogAppenderFriend
    extends SyslogAppender {
        SyslogAppenderFriend() {
        }

        public boolean isInitialized() {
            return this.sos != null;
        }
    }
}

