/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.net.mock;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockAppender
extends AppenderBase<ILoggingEvent> {
    private final Lock lock = new ReentrantLock();
    private final Condition appendCondition = this.lock.newCondition();
    private final BlockingQueue<ILoggingEvent> events = new LinkedBlockingQueue<ILoggingEvent>();

    protected void append(ILoggingEvent eventObject) {
        this.lock.lock();
        try {
            this.events.offer(eventObject);
            this.appendCondition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public ILoggingEvent awaitAppend(long delay) throws InterruptedException {
        return this.events.poll(delay, TimeUnit.MILLISECONDS);
    }

    public ILoggingEvent getLastEvent() {
        return (ILoggingEvent)this.events.peek();
    }
}

