/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.pattern.DateConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.pattern.FormattingConverter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class DateConverterTest {
    private static final String DATETIME_PATTERN = "MMM-dd HH:mm:ss.SSS";
    private static final String ENGLISH_TIME_UTC = "Sep-03 17:20:55.123";
    private static final String FRENCH_TIME_UTC = "sept.-03 17:20:55.123";
    private static final String CHINESE_TIME_UTC = "\u4e5d\u6708-03 17:20:55.123";
    private static LoggerContext _context;
    private static Logger _logger;
    private static Date _date;
    private static long _timestamp;
    private static String _isoDateString;

    @BeforeClass
    public static void beforeClass() throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(DATETIME_PATTERN, Locale.US);
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        _date = sdf.parse(ENGLISH_TIME_UTC);
        _context = new LoggerContext();
        _logger = _context.getLogger(DateConverterTest.class);
        _timestamp = _date.getTime();
        _isoDateString = DateConverterTest.formatDateWithPattern(_date, "yyyy-MM-dd HH:mm:ss,SSS", TimeZone.getDefault().getID());
    }

    @Test
    public void convertsDateAsIso8601WhenNull() {
        Assert.assertEquals((Object)_isoDateString, (Object)this.convert(_timestamp, new String[]{null}));
    }

    @Test
    public void convertsDateAsIso8601WhenSpecifiedByIsoName() {
        Assert.assertEquals((Object)_isoDateString, (Object)this.convert(_timestamp, "ISO8601"));
    }

    @Test
    public void convertsDateAsIso8601WhenInvalidPatternSpecified() {
        Assert.assertEquals((Object)_isoDateString, (Object)this.convert(_timestamp, "foo"));
    }

    @Test
    public void convertsDateWithEnglishLocaleByDefault() {
        Locale origLocale = Locale.getDefault();
        Locale.setDefault(Locale.FRANCE);
        Assert.assertEquals((Object)ENGLISH_TIME_UTC, (Object)this.convert(_timestamp, DATETIME_PATTERN, "UTC"));
        Locale.setDefault(origLocale);
    }

    @Test
    public void convertsDateWithSpecifiedLocaleLang() {
        Assert.assertEquals((Object)FRENCH_TIME_UTC, (Object)this.convert(_timestamp, DATETIME_PATTERN, "UTC", "fr"));
    }

    @Test
    public void convertsDateWithSpecifiedLocaleLangAndCountry() {
        Assert.assertEquals((Object)CHINESE_TIME_UTC, (Object)this.convert(_timestamp, DATETIME_PATTERN, "UTC", "zh,CN"));
    }

    @Test
    public void convertsDateWithCurrentTimeZoneByDefault() {
        Assert.assertEquals((Object)DateConverterTest.formatDate(TimeZone.getDefault().getID()), (Object)this.convert(_timestamp, DATETIME_PATTERN));
    }

    @Test
    public void convertsDateWithUtcWhenTimeZoneBlank() {
        Assert.assertEquals((Object)DateConverterTest.formatDate("UTC"), (Object)this.convert(_timestamp, DATETIME_PATTERN, ""));
    }

    @Test
    public void convertsDateWithUtcWhenTimeZoneUnknown() {
        Assert.assertEquals((Object)DateConverterTest.formatDate("UTC"), (Object)this.convert(_timestamp, DATETIME_PATTERN, "FakeTimeZone"));
    }

    @Test
    public void convertsDateInSpecifiedTimeZoneAsGmtOffset() {
        Assert.assertEquals((Object)DateConverterTest.formatDate("GMT-8"), (Object)this.convert(_timestamp, DATETIME_PATTERN, "GMT-8"));
    }

    @Test
    public void convertsDateInSpecifiedTimeZoneAsRawOffset() {
        Assert.assertEquals((Object)DateConverterTest.formatDate("-0800"), (Object)this.convert(_timestamp, DATETIME_PATTERN, "-0800"));
    }

    @Test
    public void convertsDateInSpecifiedTimeZoneAsTzid() {
        Assert.assertEquals((Object)DateConverterTest.formatDate("CST"), (Object)this.convert(_timestamp, DATETIME_PATTERN, "CST"));
    }

    private static String formatDate(String timeZone) {
        return DateConverterTest.formatDateWithPattern(_date, DATETIME_PATTERN, timeZone);
    }

    private static String formatDateWithPattern(Date date, String pattern, String timeZone) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern, Locale.US);
        sdf.setTimeZone(TimeZone.getTimeZone(timeZone));
        if (!timeZone.equalsIgnoreCase("UTC")) {
            MatcherAssert.assertThat((String)("unexpected UTC (time zone not found for: \"" + timeZone + "\")"), (Object)sdf.getTimeZone(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)TimeZone.getTimeZone("UTC"))));
        }
        return sdf.format(date);
    }

    private LoggingEvent makeLoggingEvent(long timestamp) {
        LoggingEvent event = new LoggingEvent(FormattingConverter.class.getName(), _logger, Level.INFO, "Some message", null, null);
        event.setTimeStamp(timestamp);
        return event;
    }

    private DateConverter getDateConverter(String ... options) {
        DateConverter converter = new DateConverter();
        converter.setContext((Context)_context);
        converter.setOptionList(Arrays.asList(options));
        return converter;
    }

    private String convert(long timestamp, String ... options) {
        DateConverter converter = this.getDateConverter(options);
        converter.start();
        return converter.convert((ILoggingEvent)this.makeLoggingEvent(timestamp));
    }
}

